% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{BiocPkgTools-cache}
\alias{BiocPkgTools-cache}
\alias{setCache}
\alias{pkgToolsCache}
\title{Manage cache for BiocPkgTools}
\usage{
setCache(
  directory = tools::R_user_dir("BiocPkgTools", "cache"),
  verbose = TRUE,
  ask = interactive()
)

pkgToolsCache(...)
}
\arguments{
\item{directory}{The file location where the cache is located. Once set
future downloads will go to this folder.}

\item{verbose}{Whether to print descriptive messages}

\item{ask}{logical (default TRUE when interactive session) Confirm the file
location of the cache directory}

\item{...}{For \code{pkgToolsCache}, arguments are passed to \code{setCache}}
}
\description{
Managing user data is important to allow use of email functions
such as \code{biocBuildEmail} and made easy with \code{BiocFileCache}.
}
\section{pkgToolsCache}{

Get the directory location of the cache. It will prompt the user to create
a cache if not already created. A specific directory can be used via
\code{setCache}.
}

\section{setCache}{

Specify the directory location of the data cache. By default, it will
got to the user's home/.cache/R and "appname" directory as specified by
\code{tools::R_user_dir} (with package="BiocPkgTools" and which="cache").
}

