% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioTIP_update_3.3_02282020.R
\name{simulation_Ic_sample}
\alias{simulation_Ic_sample}
\title{Calculating (and plot) random Ic scores (Mojtahedi et al. 2016) based on shuffling sample labelling.}
\usage{
simulation_Ic_sample(
  counts,
  sampleNo,
  Ic = NULL,
  genes,
  B = 1000,
  ylim = NULL,
  main = "simulation of samples",
  fun = c("cor", "BioTIP"),
  shrink = TRUE,
  use = c("everything", "all.obs", "complete.obs", "na.or.complete",
    "pairwise.complete.obs"),
  output = c("Ic", "PCCg", "PCCs"),
  plot = FALSE
)
}
\arguments{
\item{counts}{A numeric matrix or data frame. The rows and columns
represent unique transcript IDs (geneID) and sample names,  respectively.}

\item{sampleNo}{An integer of sample size at the tipping-point state.}

\item{Ic}{A numeric value. Ic score of identified CTS (gene-set), useful when \code{plot} is TRUE.
Default is NULL.}

\item{genes}{A character vector of identified CTS gene unique ids.}

\item{B}{An integer indicating number of times to run this simulation, default 1000.}

\item{ylim}{An integer vector of length 2. Default is NULL.}

\item{main}{A character vector. The title of the plot. Default is NULL.}

\item{fun}{An optional character string indicating the R functon to calculate correlations
for all possible pairs of columns of a matrix.
When using "BioTIP",  The method is modified to ignore missing values, analogous to how
\code{cor(X,  use = "pairwise.complete.obs")} works.
Note that the "BioTIP" option only function together with shrink = TRUE.}

\item{shrink}{A flag specifying whether to shrink the correlation or not.
This appraoch uses the method outlined by Schafer and Strimmer in
"A Shrinkage Approach to Large-Scale Covariance Matrix Estimation
and Implications for Functional Genomics" (2005)
Comparing to fun='cor', the 'BioTIP' method without shinkage is modified
to ignore missing values, analogous to how \code{cor(X, use = "pairwise.complete.obs")} works.}

\item{use}{An optional character string,  when fun=="cor",  it gives a method
for computing covariances in the presence of missing values.
This must be (an abbreviation of) one of the strings "everything", "all.obs",
"complete.obs", "na.or.complete", or "pairwise.complete.obs".}

\item{output}{A string. Please select from 'Ic',  'PCCg',  or 'PCCs'. Uses 'Ic' by default.
'PCCg' is the PCC between genes (numerator) and 'PCCs' is PCC between samples (denominator)}

\item{plot}{A Bollen value indicating whether a density plot will be plotted.}
}
\value{
A vector of \code{B} values of BioTIP (or Ic) scores calculated for the state of interest.
}
\description{
Run \code{B} times of sample-label shuffling to calculate the Ic score,
where x should be the same as the length of identified BioTiP and B is self-defined.
}
\examples{
counts = matrix(sample(1:100, 27), 3, 9)
colnames(counts) = 1:9
row.names(counts) = c('loci1', 'loci2', 'loci3')
CTS = c('loci1', 'loci2')
randomS <- simulation_Ic_sample(counts,  sampleNo=3,  Ic=3.4,  genes=CTS,  B=3, 
                       fun='BioTIP', plot=TRUE)
dim(randomS)
}
\author{
Zhezhen Wang \email{zhezhen@uchicago.edu}; Xinan H Yang \email{xyang2@uchicago.edu}
}
