% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioTIP_update_3.3_02282020.R
\name{getCTS}
\alias{getCTS}
\title{Obtain the identified BioTiP and its length}
\usage{
getCTS(maxMCI, maxMCIms)
}
\arguments{
\item{maxMCI}{A numeric vector,  whose length is the number of states.
This parameter is the maximum MCI score of each state,  and it can be obtained from the output of \code{\link{getMaxStats}}.
Names need to be included in names of \code{maxMCIms}.}

\item{maxMCIms}{A list of character vectors per state. The vectors are network nodes (e.g. transcript ids).
This parameter is the second element of the output of the function \code{\link{getMaxMCImember}}.}
}
\value{
A character vector, in which the elements are the unique IDs of the network nodes of the BioTiP.
}
\description{
getCTS obtains the identified BioTiP and its length based off of MCI scores.
}
\examples{
maxMCI <- c(a = 2.56,  b = 8.52,  c = 2.36,  d = 4.81,  e = 5.26)
maxMCIms <- list(a = c("A100",  "A293",  "C403"),  
                 b = c("B853",  "D826",  "A406"),  
                 c = c("J198",  "D103",  "B105"),  
                 d = c("K529",  "D385",  "E358"),  
                 e = c("J019",  "U926",  "N824"))
identical(names(maxMCI),  names(maxMCIms))
# TRUE
getCTS(maxMCI,  maxMCIms)
# "Length: 3"
# "B853" "D826" "A406"

}
\author{
Antonio Feliciano y Pleyto and Zhezhen Wang \email{zhezhen@uchicago.edu}
}
