% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_comparison.R
\name{module_preservation}
\alias{module_preservation}
\title{Calculate network preservation between two expression data sets}
\usage{
module_preservation(
  explist,
  ref_net = NULL,
  test_net = NULL,
  algorithm = "netrep",
  nPerm = 1000,
  nThreads = 1
)
}
\arguments{
\item{explist}{List of SummarizedExperiment objects or expression data frames
with genes (or orthogroups) in row names and samples in column names.}

\item{ref_net}{Reference network object returned by
the function \code{exp2gcn}.}

\item{test_net}{Test network object returned by the function \code{exp2gcn}.}

\item{algorithm}{Module preservation algorithm to be used. One of 'netrep'
(default, permutation-based) or WGCNA.}

\item{nPerm}{Number of permutations. Default: 1000}

\item{nThreads}{Number of threads to be used for parallel computing.
Default: 1}
}
\value{
A list containing the preservation statistics (netrep) or a ggplot
object with preservation statistics.
See \code{WGCNA::modulePreservation} or \code{NetRep::modulePreservation}
for more info.
}
\description{
Calculate network preservation between two expression data sets
}
\examples{
\donttest{
set.seed(1)
data(og.zma.osa)
data(zma.se)
data(osa.se)
og <- og.zma.osa
exp_ortho <- exp_genes2orthogroups(explist, og, summarize = "mean")
exp_ortho <- lapply(exp_ortho, function(x) filter_by_variance(x, n=1500))
# Previously calculated SFT powers
powers <- c(13, 15)
gcn_osa <- exp2gcn(exp_ortho$osa, net_type = "signed hybrid",
                   SFTpower = powers[1], cor_method = "pearson")
gcn_zma <- exp2gcn(exp_ortho$zma, net_type = "signed hybrid",
                   SFTpower = powers[2], cor_method = "pearson")
explist <- exp_ortho
ref_net <- gcn_osa
test_net <- gcn_zma
# 10 permutations for demonstration purposes
pres <- module_preservation(explist, ref_net, test_net, nPerm=10)
}

}
