% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcn_inference.R
\name{SFT_fit}
\alias{SFT_fit}
\title{Pick power to fit network to a scale-free topology}
\usage{
SFT_fit(exp, net_type = "signed", rsquared = 0.8, cor_method = "spearman")
}
\arguments{
\item{exp}{A gene expression data frame with genes in row names and
samples in column names or a `SummarizedExperiment` object.}

\item{net_type}{Network type. One of 'signed', 'signed hybrid' or
'unsigned'. Default is signed.}

\item{rsquared}{R squared cutoff. Default is 0.8.}

\item{cor_method}{Correlation method. One of "pearson", "biweight"
or "spearman". Default is "spearman".}
}
\value{
A list containing:
\itemize{
  \item{\strong{power} Numeric, optimal power based on scale-free topology fit}
  \item{\strong{plot} A ggplot object displaying main statistics of the SFT fit test}
}
}
\description{
Pick power to fit network to a scale-free topology
}
\examples{
data(filt.se)
sft <- SFT_fit(filt.se, cor_method = "pearson")
}
\seealso{
\code{\link[WGCNA]{pickSoftThreshold}}
}
\author{
Fabricio Almeida-Silva
}
