% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{selection_cpp}
\alias{selection_cpp}
\title{Function to select individuals based on fitness scores}
\usage{
selection_cpp(population, fitness, num_parents)
}
\arguments{
\item{population}{Numeric matrix representing the population of
individuals.}

\item{fitness}{Numeric vector of fitness scores for each individual.}

\item{num_parents}{Number of individuals to select.}
}
\value{
Numeric matrix representing the selected individuals.
}
\description{
Function to select individuals based on fitness scores
}
\examples{
# example of usage
genomic_data <- matrix(rnorm(100), nrow = 10, ncol = 10)
population <- BioGA::initialize_population_cpp(genomic_data,
                population_size = 5)
fitness <- BioGA::evaluate_fitness_cpp(genomic_data, population)
BioGA::selection_cpp(population, fitness, num_parents = 2)
}
