% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgeneSim.R
\name{mgeneSim}
\alias{mgeneSim}
\alias{mgeneSim,character,GeneSetCollection-method}
\alias{mgeneSim,missing,GeneSetCollection-method}
\title{Similarity score genes based on pathways similarity}
\usage{
mgeneSim(genes, info, method = "max", ...)

\S4method{mgeneSim}{character,GeneSetCollection}(genes, info, method = "max", ...)

\S4method{mgeneSim}{missing,GeneSetCollection}(genes, info, method = "max", ...)
}
\arguments{
\item{genes}{A vector of genes.}

\item{info}{A GeneSetCollection or a list of genes and the pathways they are
involved.}

\item{method}{one of \code{c("avg", "max", "rcmax", "rcmax.avg", "BMA", "reciprocal")}, see Details.}

\item{...}{Other arguments passed to \code{combineScores}}
}
\value{
\code{mgeneSim} returns the matrix of similarities between the genes
in the vector
}
\description{
Given two genes, calculates the Dice similarity between each pathway
which is combined to obtain a similarity between the genes.
}
\details{
Given the information about the genes and their pathways, uses the ids
of the genes to find the Dice similarity score for each pathway comparison
between the genes. Later this similarities are combined using
\code{\link[=combineScoresPar]{combineScoresPar()}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{mgeneSim(genes = character, info = GeneSetCollection)}: Calculates all the similarities of the list and
combine them using \code{\link[=combineScoresPar]{combineScoresPar()}}

\item \code{mgeneSim(genes = missing, info = GeneSetCollection)}: Calculates all the similarities of the list and
combine them using \code{\link[=combineScoresPar]{combineScoresPar()}}

}}
\note{
genes accept named characters and the output will use the names of the
genes.
}
\examples{
if (require("org.Hs.eg.db") & require("reactome.db")) {
    # Extract the paths of all genes of org.Hs.eg.db from KEGG
    # (last update in data of June 31st 2011)
    genes.kegg <- as.list(org.Hs.egPATH)
    # Extracts the paths of all genes of org.Hs.eg.db from reactome
    genes.react <- as.list(reactomeEXTID2PATHID)
    mgeneSim(c("81", "18", "10"), genes.react)
    mgeneSim(c("81", "18", "10"), genes.react, "avg")
    named_genes <- structure(c("81", "18", "10"),
        .Names = c("ACTN4", "ABAT", "NAT2")
    )
    mgeneSim(named_genes, genes.react, "max")
} else {
    warning("You need reactome.db and org.Hs.eg.db package for this example")
}
}
\seealso{
\code{\link[=geneSim]{geneSim()}}, \code{\link[=conversions]{conversions()}} help page to transform Dice
score to Jaccard score. For the method to combine the scores see
\code{\link[=combineScoresPar]{combineScoresPar()}}.
}
