% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioCor-package.R
\docType{package}
\name{BioCor-package}
\alias{BioCor}
\alias{BioCor-package}
\title{BioCor: A package to calculate functional similarities}
\description{
Calculates a functional similarity measure between gene identifiers
based on the pathways described on KEGG and REACTOME.
}
\section{Important functions}{

\itemize{
\item \strong{\code{\link[=pathSim]{pathSim()}}}: Calculates the similarity between two pathways.
\item \strong{\code{\link[=geneSim]{geneSim()}}}: Calculates the similarity (based on pathSim)
between two genes.
\item \strong{\code{\link[=clusterSim]{clusterSim()}}}: Calculates the similarity between two
clusters of genes by joining pathways of each gene.
\item \strong{\code{\link[=clusterGeneSim]{clusterGeneSim()}}}: Calculates the similarity between two
clusters of genes by comparing the similarity between the genes of a cluster.
\item \strong{\code{\link[=similarities]{similarities()}}}: Allows to combine the value of matrices of
similarities.
\item \strong{\code{\link[=conversions]{conversions()}}}: Two functions to convert similarity
measures.
\item \strong{\code{\link[=weighted]{weighted()}}}: Functions provided to combine similarities.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://bioconductor.org/packages/BioCor}
  \item \url{https://biocor.llrs.dev}
  \item Report bugs at \url{https://github.com/llrs/BioCor/issues}
}

}
\author{
\strong{Maintainer}: Lluís Revilla Sancho \email{lluis.revilla@gmail.com} (\href{https://orcid.org/0000-0001-9747-2570}{ORCID})

Other contributors:
\itemize{
  \item Pau Sancho-Bru (\href{https://orcid.org/0000-0001-5569-9259}{ORCID}) [thesis advisor]
  \item Juan José Salvatella Lozano (\href{https://orcid.org/0000-0001-7613-3908}{ORCID}) [thesis advisor]
}

}
