% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserMetadata.R
\docType{methods}
\name{setTranscriptomeFromFile}
\alias{setTranscriptomeFromFile}
\alias{setTranscriptomeFromFile,UserMetadata,character,missing-method}
\alias{setTranscriptomeFromFile,userMetadata,character,missing}
\alias{setTranscriptomeFromFile,UserMetadata,character,character-method}
\alias{setTranscriptomeFromFile,userMetadata,character,character}
\title{Set transcriptome_object of one UserMetadata object}
\usage{
setTranscriptomeFromFile(userObject, transcriptomePath, transcriptomeName)

\S4method{setTranscriptomeFromFile}{UserMetadata,character,missing}(userObject, transcriptomePath, transcriptomeName)

\S4method{setTranscriptomeFromFile}{UserMetadata,character,character}(userObject, transcriptomePath, transcriptomeName)
}
\arguments{
\item{userObject}{The UserMetadata object}

\item{transcriptomePath}{Absolute path to the transcriptome file}

\item{transcriptomeName}{(optional) Name of the trancriptome. Will be used to
create folders.}
}
\value{
An object of the class UserMetadata
}
\description{
Method of the class UserMetadata. Set transcriptome_object of
one UserMetadata object
by providing the path to a fasta transcriptome file.
}
\details{
If no transcriptomeName is provided the name of the transcriptome file
will be used to create folders.
}
\examples{
{
transcriptome_path <- system.file("extdata", "transcriptome.fa", package = "BgeeCall")
user <- new("UserMetadata")
user <- setTranscriptomeFromFile(user, transcriptome_path,
                                 "transcriptome_name")
}

}
