% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_aic.R
\name{compute_aic}
\alias{compute_aic}
\title{Compute the AIC for lognormal (ComBat) model, negative binomial (ComBat-seq)
model and the Voom model}
\usage{
compute_aic(
  se,
  assay_of_interest,
  batchind,
  groupind,
  maxit = 25,
  zero_filt_percent = 100
)
}
\arguments{
\item{se}{SummarizedExperiment object}

\item{assay_of_interest}{The assay name from se that you are interested in
analyzing. This assay need to be a counts assay containing only non-negative
integers.}

\item{batchind}{Factor or numeric vector of length = ncol(dat);
batch indicator for each sample.}

\item{groupind}{Factor or numeric vector of length = ncol(dat);
biological group label/indicator for each sample.}

\item{maxit}{Integer giving the maximal number of IWLS iterations. Default is
25.}

\item{zero_filt_percent}{Numeric value between 0 and 100, the percentage of
zeros allowed for each gene to be included in the AIC calculation. Genes with
more than this percentage of zeros will be filtered out. Default is 100.}
}
\value{
A list with the following two elements:
\describe{
\item{total_AIC}{The sum of AICs across all genes for the three models
in comparison.}
\item{min_AIC}{The number of minimum AIC across the three models in
comparison for individual genes.}
}
}
\description{
\describe{
\item{nb_result}{A vector contains the AIC based on negative binomial
model for individual genes.}
\item{lognormal_result}{A vector contains the AIC based on lognormal
model for individual genes.}
\item{voom_result}{A vector contains the AIC based on voom transformation
for individual genes.}
\item{total_AIC}{The sum of AICs across all genes for the three models
in comparison.}
\item{min_AIC}{The number of minimum AIC across the three models in
comparison for individual genes.}
}
}
\details{
This function calculates the AIC based on lognormal distribution,
negative-binomial distribution as well as the Voom transformation.
It then compares the AICs of the three models across different genes.
}
\examples{
library(scran)
se <- mockSCE()
compare_aic <- compute_aic(se, assay_of_interest = "counts",
                            batchind = "Cell_Cycle",
                            groupind = c("Treatment", "Mutation_Status"))
print(compare_aic["total_AIC"])
print(compare_aic["min_AIC"])

}
