% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velocity.R
\name{subset_annot}
\alias{subset_annot}
\alias{subset_annot,DNAStringSet-method}
\alias{subset_annot,BSgenome-method}
\title{Subset genome annotation}
\usage{
subset_annot(Genome, annot)

\S4method{subset_annot}{DNAStringSet}(Genome, annot)

\S4method{subset_annot}{BSgenome}(Genome, annot)
}
\arguments{
\item{Genome}{Either a \code{\link{BSgenome}} or a \code{\link{XStringSet}}
object of genomic sequences, where the intronic sequences will be extracted
from. Use \code{\link{genomeStyles}} to check which styles are supported for
your organism of interest; supported styles can be interconverted. If the
style in your genome or annotation is not supported, then the style of
chromosome names in the genome and annotation should be manually set to be
consistent.}

\item{annot}{Either a \code{GRanges} object or a \code{TxDb} object for gene
annotation.}
}
\value{
A subsetted genome annotation of the same type of the input genome
annotation.
}
\description{
Exclude chromosomes present in the annotation but absent from the genome and
add information about circular chromosomes.
}
\examples{
library(BSgenome.Hsapiens.UCSC.hg38)
library(EnsDb.Hsapiens.v86) 
library(GenomeInfoDb)
gn <- BSgenome.Hsapiens.UCSC.hg38
seqlevelsStyle(gn) <- "Ensembl"
subset_annot(gn, EnsDb.Hsapiens.v86)

}
