% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneAnalysis.R
\name{intraAnalysisClassic}
\alias{intraAnalysisClassic}
\title{Intra-experiment analysis in conjunction with classical 
hypothesis tests}
\usage{
intraAnalysisClassic(x, y = NULL, splitSize = 5, metaMethod = addCLT,
  func = t.test, p.value = "p.value", ...)
}
\arguments{
\item{x}{a numeric vector of data values}

\item{y}{an optional numeric vector of values}

\item{splitSize}{the minimum number of size in each split sample. 
splitSize should be at least 3. By default, splitSize=5}

\item{metaMethod}{the method used to combine p-values. This should be one 
of addCLT (additive method [1]), fishersMethod (Fisher's method [5]), 
stoufferMethod (Stouffer's method [6]), max (maxP method [7]), 
or min (minP method [8])}

\item{func}{the name of the hypothesis test. By default func=t.test}

\item{p.value}{the component that returns the p-value after performing 
the test provided by the \emph{func} parameter. For example, the function 
t-test returns the class "htest" where the component "p.value" is the 
p-value of the test. By default, p.value="p.value"}

\item{...}{additional parameters for \emph{func}}
}
\value{
intra-experiment p-value
}
\description{
Perform an intra-experiment analysis in conjunction with any 
of the classical hypothesis testing methods, such as t-test, 
Wilcoxon test, etc.
}
\details{
This function performs an intra-experiment analysis for the given 
sample(s) [1]. Given x as the numeric vector, this function first splits x 
into smaller samples with size \emph{splitSize}, performs hypothesis 
testing using \emph{func}, and then combines the p-values 
using \emph{metaMethod}
}
\examples{
set.seed(1)
x <- rnorm(10, mean = 0)
# p-value obtained from a one-sample t-test
t.test(x, mu=1, alternative = "less")$p.value
# p-value obtained from an intra-experiment analysis
intraAnalysisClassic(x, func=t.test, mu=1, alternative = "less")

# p-value obtained from a one-sample wilcoxon test
wilcox.test(x, mu=1, alternative = "less")$p.value
# p-value obtained from an intra-experiment analysis
intraAnalysisClassic(x, func=wilcox.test, mu=1, alternative = "less")

set.seed(1)
x <- rnorm(20, mean=0); y <- rnorm(20, mean=1)
# p-value obtained from a two-sample t-test
t.test(x,y,alternative="less")$p.value
# p-value obtained from an intra-experiment analysis
intraAnalysisClassic(x, y, func=t.test, alternative = "less")
# p-value obtained from a two-sample wilcoxon test
wilcox.test(x,y,alternative="less")$p.value
# p-value obtained from an intra-experiment analysis
intraAnalysisClassic(x, y, func=wilcox.test, alternative = "less")

}
\author{
Tin Nguyen and Sorin Draghici
}
\references{
[1] T. Nguyen, R. Tagett, M. Donato, C. Mitrea, and S. Draghici. A novel 
bi-level meta-analysis approach -- applied to biological pathway analysis. 
Bioinformatics, 32(3):409-416, 2016.
}
\seealso{
\code{\link{bilevelAnalysisClassic}}, \code{\link{intraAnalysisGene}}, \code{\link{bilevelAnalysisGene}}
}

