% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PathwayAnalysis.R
\name{bilevelAnalysisPathway}
\alias{bilevelAnalysisPathway}
\title{Bi-level meta-analysis -- applied to pathway analysis}
\usage{
bilevelAnalysisPathway(kpg, kpn, dataList, groupList, splitSize = 5,
  metaMethod = addCLT, pCutoff = 0.05, percent = 0.05, mc.cores = 1,
  nboot = 200, seed = 1)
}
\arguments{
\item{kpg}{list of pathway graphs as objects of type graph 
(e.g., \code{\link{graphNEL}})}

\item{kpn}{names of the pathways.}

\item{dataList}{a list of datasets to be combined. Each dataset is a data 
frame where the rows are the gene IDs and the columns are the samples.}

\item{groupList}{a list of vectors. Each vector represents the phenotypes 
of the corresponding dataset in dataList, which are either 'c' (control) 
or 'd' (disease).}

\item{splitSize}{the minimum number of disease samples in each split 
dataset. splitSize should be at least 3. By default, splitSize=5}

\item{metaMethod}{the method used to combine p-values. This should be one 
of addCLT (additive method [1]), fisherMethod (Fisher's method [5]), 
stoufferMethod (Stouffer's method [6]), max (maxP method [7]), or 
min (minP method [8])}

\item{pCutoff}{cutoff p-value used to identify differentially 
expressed (DE) genes. This parameter is used only when the enrichment 
method is "ORA". By default, pCutoff=0.05 (five percent)}

\item{percent}{percentage of genes with highest foldchange to be considered 
as differentially expressed (DE). This parameter is used when the enrichment 
method is "ORA". By default percent=0.05 (five percent). Please note that 
only genes with p-value less than pCutoff will be considered}

\item{mc.cores}{the number of cores to be used in parallel computing. 
By default, mc.cores=1}

\item{nboot}{number of bootstrap iterations. By default, nboot=200}

\item{seed}{seed. By default, seed=1.}
}
\value{
A data frame (rownames are geneset/pathway IDs) that consists of the 
following information:
\itemize{
\item \emph{Name:} name/description of the corresponding pathway/geneset
\item Columns that include the pvalues obtained from the intra-experiment 
analysis of individual datasets
\item \emph{pBLMA:} p-value obtained from the inter-experiment 
analysis using addCLT
\item \emph{rBLMA:} ranking of the geneset/pathway using addCLT
\item \emph{pBLMA.fdr:} FDR-corrected p-values
}
}
\description{
Perform a bi-level meta-analysis conjunction with 
Impact Analysis to integrate multiple gene expression datasets
}
\details{
The bi-level framework combines the datasets at two levels: an 
intra-experiment analysis, and an inter-experiment analysis [1]. At the 
intra-level analysis, the framework splits a dataset into smaller datasets, 
performs pathway analysis for each split dataset using 
Impact Analysis [2,3], and then combines the results of these split datasets 
using \emph{metaMethod}. At the inter-level analysis, the results obtained 
for individual datasets are combined using \emph{metaMethod}
}
\examples{
# load KEGG pathways
x <- loadKEGGPathways()  

# load example data
dataSets <- c("GSE17054", "GSE57194", "GSE33223", "GSE42140")
data(list=dataSets, package="BLMA")
names(dataSets) <- dataSets
dataList <- lapply(dataSets, function(dataset) get(paste0("data_", dataset)))
groupList <- lapply(dataSets, function(dataset) get(paste0("group_", dataset)))

IAComb <- bilevelAnalysisPathway(x$kpg, x$kpn, dataList, groupList)
head(IAComb[, c("Name", "pBLMA", "pBLMA.fdr", "rBLMA")])

}
\author{
Tin Nguyen and Sorin Draghici
}
\references{
[1] T. Nguyen, R. Tagett, M. Donato, C. Mitrea, and S. Draghici. A novel 
bi-level meta-analysis approach -- applied to biological pathway analysis. 
Bioinformatics, 32(3):409-416, 2016.

[2] A. L. Tarca, S. Draghici, P. Khatri, S. S. Hassan, P. Mittal, 
J.-s. Kim, C. J. Kim, J. P. Kusanovic, and R. Romero. A novel signaling 
pathway impact analysis. Bioinformatics, 25(1):75-82, 2009.

[3] S. Draghici, P. Khatri, A. L. Tarca, K. Amin, A. Done, C. Voichita, 
C. Georgescu, and R. Romero. A systems biology approach for pathway 
level analysis. Genome Research, 17(10):1537-1545, 2007.

[4] R. A. Fisher. Statistical methods for research workers. 
Oliver & Boyd, Edinburgh, 1925.

[5] S. Stouffer, E. Suchman, L. DeVinney, S. Star, and J. Williams, RM. 
The American Soldier: Adjustment during army life, volume 1. 
Princeton University Press, Princeton, 1949.

[6] L. H. C. Tippett. The methods of statistics. 
The Methods of Statistics, 1931.

[7] B. Wilkinson. A statistical consideration in psychological research. 
Psychological Bulletin, 48(2):156, 1951.
}
\seealso{
\code{\link{bilevelAnalysisGeneset}}, \code{\link{pe}}, \code{\link{phyper}}
}

