% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{as.matrix,varPartResults-method}
\alias{as.matrix,varPartResults-method}
\alias{as.matrix}
\title{Convert to matrix}
\usage{
\S4method{as.matrix}{varPartResults}(x, ...)
}
\arguments{
\item{x}{varPartResults}

\item{...}{other arguments.}
}
\value{
matrix
}
\description{
Convert varPartResults to matrix
}
\examples{
# load library
# library(variancePartition)

# load simulated data:
# geneExpr: matrix of gene expression values
# info: information/metadata about each sample
data(varPartData)

# Specify variables to consider
# Age is continuous so we model it as a fixed effect
# Individual and Tissue are both categorical, so we model them as random effects
form <- ~ Age + (1 | Individual) + (1 | Tissue)

# Fit model
varPart <- fitExtractVarPartModel(geneExpr[1:5, ], form, info)

# convert to matrix
as.matrix(varPart)

}
