% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_motifs.R
\name{read_motifs}
\alias{read_motifs}
\title{Import universalmotif formatted motifs.}
\usage{
read_motifs(file, skip = 0, progress = FALSE, BP = FALSE)
}
\arguments{
\item{file}{\code{character(1)} File name.}

\item{skip}{\code{numeric(1)} If not zero, will skip however many desired lines in the
file before starting to read.}

\item{progress}{\code{logical(1)} Show progress.}

\item{BP}{\code{logical(1)} Allows for the use of \pkg{BiocParallel} within
\code{\link[=read_motifs]{read_motifs()}}. See \code{\link[BiocParallel:register]{BiocParallel::register()}} to change the
default backend.}
}
\value{
\code{list} \linkS4class{universalmotif} objects.
}
\description{
Import motifs created from \code{\link[=write_motifs]{write_motifs()}}. For optimal storage of
\code{universalmotif} class motifs, consider using \code{\link[=saveRDS]{saveRDS()}} and
\code{\link[=readRDS]{readRDS()}}. Currently the \code{universalmotif} format is YAML-based, but
this is subject to change.
}
\seealso{
Other read_motifs: 
\code{\link{read_cisbp}()},
\code{\link{read_homer}()},
\code{\link{read_jaspar}()},
\code{\link{read_matrix}()},
\code{\link{read_meme}()},
\code{\link{read_transfac}()},
\code{\link{read_uniprobe}()}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
\concept{read_motifs}
