% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_meme.R
\name{read_meme}
\alias{read_meme}
\title{Import MEME motifs.}
\usage{
read_meme(file, skip = 0, readsites = FALSE, readsites.meta = FALSE,
  readsites.meta.tidy = FALSE)
}
\arguments{
\item{file}{\code{character(1)} File name.}

\item{skip}{\code{numeric(1)} If not zero, will skip however many desired lines in the
file before starting to read.}

\item{readsites}{\code{logical(1)} If \code{TRUE}, the motif sites will be read as well.}

\item{readsites.meta}{\code{logical(1)} If \code{readsites = TRUE}, then additionally
read site positions and P-values.}

\item{readsites.meta.tidy}{\code{logical(1)} If \code{readsites.meta = TRUE}, merge the
position site information for all motifs into a single tidy \code{data.frame}.}
}
\value{
\code{list} \linkS4class{universalmotif} objects. If \code{readsites = TRUE}, a list
comprising of a sub-list of motif objects and a sub-list of
motif sites will be returned. If \code{readsites.meta = TRUE}, then two
additional list items will be present, one containing site positions
and P-values, and another containing combined sequence p-values. If
\code{readsites.meta.tidy = TRUE}, an additional list entry named
\code{sites.meta.tidy} will be added containing a \code{data.frame}.
}
\description{
Import MEME formatted motifs, as well as original motif sequences. See
\url{http://meme-suite.org/doc/meme-format.html}. Both 'full' and 'minimal'
formats are supported. DREME and STREME motifs can also be imported, but note
that \code{readsites} and \code{readsites.meta} arguments do nothing.
}
\details{
Please note that the typical number precision limit in R is around 1e-308.
This means that motif P-values in MEME files below this limit are rounded
automatically to 0. To get around this, the E-value is also stored as a
string in the \code{extrainfo} slot. If you require a numeric value for analysis,
use the \code{\link[=log_string_pval]{log_string_pval()}} function to get the log of the string-formatted
p-value.
}
\examples{
meme.minimal <- read_meme(system.file("extdata", "meme_minimal.txt",
                                      package = "universalmotif"))
meme.full <- read_meme(system.file("extdata", "meme_full.txt",
                                   package = "universalmotif"))
## Get numeric p-value:
log_string_pval(meme.minimal[[1]]["extrainfo"]["eval.string"])

}
\references{
Bailey TL, Boden M, Buske FA, Frith M, Grant CE, Clementi L, Ren
J, Li WW, Noble WS (2009). “MEME SUITE: tools for motif discovery
and searching.” \emph{Nucleic Acids Research}, \strong{37}, W202-W208.
}
\seealso{
Other read_motifs: 
\code{\link{read_cisbp}()},
\code{\link{read_homer}()},
\code{\link{read_jaspar}()},
\code{\link{read_matrix}()},
\code{\link{read_motifs}()},
\code{\link{read_transfac}()},
\code{\link{read_uniprobe}()}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
\concept{read_motifs}
