% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_motifs.R
\name{merge_motifs}
\alias{merge_motifs}
\title{Merge motifs.}
\usage{
merge_motifs(motifs, method = "ALLR", use.type = "PPM", min.overlap = 6,
  min.mean.ic = 0.25, tryRC = TRUE, relative_entropy = FALSE,
  normalise.scores = FALSE, min.position.ic = 0, score.strat = "sum",
  new.name = NULL)
}
\arguments{
\item{motifs}{See \code{\link[=convert_motifs]{convert_motifs()}} for acceptable motif formats.}

\item{method}{\code{character(1)} One of PCC, EUCL, SW, KL, ALLR, BHAT, HELL,
SEUCL, MAN, ALLR_LL, WEUCL, WPCC. See details.}

\item{use.type}{\code{character(1)} One of \code{'PPM'} and \code{'ICM'}.
The latter allows for taking into account the background
frequencies if \code{relative_entropy = TRUE}. Note that \code{'ICM'} is not
allowed when \code{method = c("ALLR", "ALLR_LL")}.}

\item{min.overlap}{\code{numeric(1)} Minimum overlap required when aligning the
motifs. Setting this to a number higher then the width of the motifs
will not allow any overhangs. Can also be a number between 0 and 1,
representing the minimum fraction that the motifs must overlap.}

\item{min.mean.ic}{\code{numeric(1)} Minimum mean information content between the
two motifs for an alignment to be scored. This helps prevent scoring
alignments between low information content regions of two motifs. Note that
this can result in some comparisons failing if no alignment passes the
mean IC threshold. Use \code{\link[=average_ic]{average_ic()}} to filter out low IC motifs to get around
this if you want to avoid getting \code{NA}s in your output.}

\item{tryRC}{\code{logical(1)} Try the reverse complement of the motifs as well,
report the best score.}

\item{relative_entropy}{\code{logical(1)} Change the ICM calculation affecting
\code{min.position.ic} and \code{min.mean.ic}. See \code{\link[=convert_type]{convert_type()}}.}

\item{normalise.scores}{\code{logical(1)} Favour alignments which leave fewer
unaligned positions, as well as alignments between motifs of similar length.
Similarity scores are multiplied by the ratio of
aligned positions to the total number of positions in the larger motif,
and the inverse for distance scores.}

\item{min.position.ic}{\code{numeric(1)} Minimum information content required between
individual alignment positions for it to be counted in the final alignment
score. It is recommended to use this together with \code{normalise.scores = TRUE},
as this will help punish scores resulting from only a fraction of an
alignment.}

\item{score.strat}{\code{character(1)} How to handle column scores calculated from
motif alignments. "sum": add up all scores. "a.mean": take the arithmetic
mean. "g.mean": take the geometric mean. "median": take the median.
"wa.mean", "wg.mean": weighted arithmetic/geometric mean. "fzt": Fisher
Z-transform. Weights are the
total information content shared between aligned columns.}

\item{new.name}{\code{character(1)}, \code{NULL} Instead of collapsing existing names (if \code{NULL}),
assign a new one manually for the merged motif.}
}
\value{
A single motif object. See \code{\link[=convert_motifs]{convert_motifs()}} for
available formats.
}
\description{
Aligns the motifs using \code{\link[=compare_motifs]{compare_motifs()}}, then averages the
motif PPMs. Currently the \code{multifreq} slot, if filled in any of the motifs,
will be dropped. Only 0-order background probabilities will be kept.
Motifs are merged one at a time, starting with the first entry in the
list.
}
\details{
See \code{\link[=compare_motifs]{compare_motifs()}} for more info on comparison parameters.

If using a comparison metric where 0s are not allowed (\code{KL}, \code{ALLR}, \code{ALLR_LL}, \code{IS}),
then pseudocounts will be added internally. These pseudocounts are only used for
comparison and alignment, and are not used in the final merging step.

Note: \code{score.strat = "a.mean"} is NOT recommended, as \code{\link[=merge_motifs]{merge_motifs()}} will
not discriminate between two alignments with equal mean scores, even if one
alignment is longer than the other.
}
\examples{
\dontrun{
library(MotifDb)
merged.motif <- merge_motifs(MotifDb[1:5])
}

m1 <- create_motif("TTAAACCCC", name = "1")
m2 <- create_motif("AACC", name = "2")
m3 <- create_motif("AACCCCGG", name = "3")
view_motifs(merge_motifs(c(m1, m2, m3)))

}
\seealso{
\code{\link[=compare_motifs]{compare_motifs()}}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
