% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_abundance.R
\docType{methods}
\name{scale_abundance}
\alias{scale_abundance}
\alias{scale_abundance,SummarizedExperiment-method}
\alias{scale_abundance,RangedSummarizedExperiment-method}
\title{Scale the counts of transcripts/genes}
\usage{
scale_abundance(
  .data,
  abundance = assayNames(.data)[1],
  method = "TMM",
  reference_sample = NULL,
  .subset_for_scaling = NULL,
  suffix = "_scaled",
  reference_selection_function = NULL,
  ...,
  .abundance = NULL
)

\S4method{scale_abundance}{SummarizedExperiment}(
  .data,
  abundance = assayNames(.data)[1],
  method = "TMM",
  reference_sample = NULL,
  .subset_for_scaling = NULL,
  suffix = "_scaled",
  reference_selection_function = NULL,
  ...,
  .abundance = NULL
)

\S4method{scale_abundance}{RangedSummarizedExperiment}(
  .data,
  abundance = assayNames(.data)[1],
  method = "TMM",
  reference_sample = NULL,
  .subset_for_scaling = NULL,
  suffix = "_scaled",
  reference_selection_function = NULL,
  ...,
  .abundance = NULL
)
}
\arguments{
\item{.data}{A `tbl` (with at least three columns for sample, feature and transcript abundance) or `SummarizedExperiment` (more convenient if abstracted to tibble with library(tidySummarizedExperiment))}

\item{abundance}{The name of the transcript/gene abundance column (character, preferred)}

\item{method}{A character string. The scaling method passed to the back-end function (i.e., edgeR::calcNormFactors; "TMM","TMMwsp","RLE","upperquartile")}

\item{reference_sample}{A character string. The name of the reference sample. If NULL the sample with highest total read count will be selected as reference.}

\item{.subset_for_scaling}{A gene-wise quosure condition. This will be used to filter rows (features/genes) of the dataset. For example}

\item{suffix}{A character string to append to the scaled abundance column name. Default is "_scaled".}

\item{reference_selection_function}{DEPRECATED. please use reference_sample.}

\item{...}{Further arguments.}

\item{.abundance}{DEPRECATED. The name of the transcript/gene abundance column (symbolic, for backward compatibility)}
}
\value{
A tbl object with additional columns with scaled data as `<NAME OF COUNT COLUMN>_scaled`

A `SummarizedExperiment` object

A `SummarizedExperiment` object
}
\description{
scale_abundance() takes as input A `tbl` (with at least three columns for sample, feature and transcript abundance) or `SummarizedExperiment` (more convenient if abstracted to tibble with library(tidySummarizedExperiment)) and Scales transcript abundance compansating for sequencing depth (e.g., with TMM algorithm, Robinson and Oshlack doi.org/10.1186/gb-2010-11-3-r25).
}
\details{
`r lifecycle::badge("maturing")`

Scales transcript abundance compensating for sequencing depth
(e.g., with TMM algorithm, Robinson and Oshlack doi.org/10.1186/gb-2010-11-3-r25).
Lowly transcribed transcripts/genes (defined with minimum_counts and minimum_proportion parameters)
are filtered out from the scaling procedure.
The scaling inference is then applied back to all unfiltered data.

Underlying method
edgeR::calcNormFactors(.data, method = c("TMM","TMMwsp","RLE","upperquartile"))
}
\examples{
## Load airway dataset for examples

  data('airway', package = 'airway')
  # Ensure a 'condition' column exists for examples expecting it

    SummarizedExperiment::colData(airway)$condition <- SummarizedExperiment::colData(airway)$dex




 airway |>
   identify_abundant() |>
   scale_abundance()

}
\references{
Mangiola, S., Molania, R., Dong, R., Doyle, M. A., & Papenfuss, A. T. (2021). tidybulk: an R tidy framework for modular transcriptomic data analysis. Genome Biology, 22(1), 42. doi:10.1186/s13059-020-02233-7

Robinson, M. D., & Oshlack, A. (2010). A scaling normalization method for differential expression analysis of RNA-seq data. Genome Biology, 11(3), R25. doi:10.1186/gb-2010-11-3-r25
}
