% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr_methods.R
\name{pivot_wider}
\alias{pivot_wider}
\alias{pivot_wider.SummarizedExperiment}
\title{Pivot data from long to wide}
\usage{
\method{pivot_wider}{SummarizedExperiment}(
  data,
  ...,
  id_cols = NULL,
  id_expand = FALSE,
  names_from = name,
  names_prefix = "",
  names_sep = "_",
  names_glue = NULL,
  names_sort = FALSE,
  names_vary = "fastest",
  names_expand = FALSE,
  names_repair = "check_unique",
  values_from = value,
  values_fill = NULL,
  values_fn = NULL,
  unused_fn = NULL
)
}
\arguments{
\item{data}{A data frame to pivot.}

\item{...}{Additional arguments passed on to methods.}

\item{id_cols}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> A set of columns that
uniquely identify each observation. Typically used when you have
redundant variables, i.e. variables whose values are perfectly correlated
with existing variables.

Defaults to all columns in \code{data} except for the columns specified through
\code{names_from} and \code{values_from}. If a tidyselect expression is supplied, it
will be evaluated on \code{data} after removing the columns specified through
\code{names_from} and \code{values_from}.}

\item{id_expand}{Should the values in the \code{id_cols} columns be expanded by
\code{\link[tidyr:expand]{expand()}} before pivoting? This results in more rows, the output will
contain a complete expansion of all possible values in \code{id_cols}. Implicit
factor levels that aren't represented in the data will become explicit.
Additionally, the row values corresponding to the expanded \code{id_cols} will
be sorted.}

\item{names_from, values_from}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> A pair of
arguments describing which column (or columns) to get the name of the
output column (\code{names_from}), and which column (or columns) to get the
cell values from (\code{values_from}).

If \code{values_from} contains multiple values, the value will be added to the
front of the output column.}

\item{names_prefix}{String added to the start of every variable name. This is
particularly useful if \code{names_from} is a numeric vector and you want to
create syntactic variable names.}

\item{names_sep}{If \code{names_from} or \code{values_from} contains multiple
variables, this will be used to join their values together into a single
string to use as a column name.}

\item{names_glue}{Instead of \code{names_sep} and \code{names_prefix}, you can supply
a glue specification that uses the \code{names_from} columns (and special
\code{.value}) to create custom column names.}

\item{names_sort}{Should the column names be sorted? If \code{FALSE}, the default,
column names are ordered by first appearance.}

\item{names_vary}{When \code{names_from} identifies a column (or columns) with
multiple unique values, and multiple \code{values_from} columns are provided,
in what order should the resulting column names be combined?
\itemize{
\item \code{"fastest"} varies \code{names_from} values fastest, resulting in a column
naming scheme of the form: \verb{value1_name1, value1_name2, value2_name1, value2_name2}. This is the default.
\item \code{"slowest"} varies \code{names_from} values slowest, resulting in a column
naming scheme of the form: \verb{value1_name1, value2_name1, value1_name2, value2_name2}.
}}

\item{names_expand}{Should the values in the \code{names_from} columns be expanded
by \code{\link[tidyr:expand]{expand()}} before pivoting? This results in more columns, the output
will contain column names corresponding to a complete expansion of all
possible values in \code{names_from}. Implicit factor levels that aren't
represented in the data will become explicit. Additionally, the column
names will be sorted, identical to what \code{names_sort} would produce.}

\item{names_repair}{What happens if the output has invalid column names?
The default, \code{"check_unique"} is to error if the columns are duplicated.
Use \code{"minimal"} to allow duplicates in the output, or \code{"unique"} to
de-duplicated by adding numeric suffixes. See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}
for more options.}

\item{values_fill}{Optionally, a (scalar) value that specifies what each
\code{value} should be filled in with when missing.

This can be a named list if you want to apply different fill values to
different value columns.}

\item{values_fn}{Optionally, a function applied to the value in each cell
in the output. You will typically use this when the combination of
\code{id_cols} and \code{names_from} columns does not uniquely identify an
observation.

This can be a named list if you want to apply different aggregations
to different \code{values_from} columns.}

\item{unused_fn}{Optionally, a function applied to summarize the values from
the unused columns (i.e. columns not identified by \code{id_cols},
\code{names_from}, or \code{values_from}).

The default drops all unused columns from the result.

This can be a named list if you want to apply different aggregations
to different unused columns.

\code{id_cols} must be supplied for \code{unused_fn} to be useful, since otherwise
all unspecified columns will be considered \code{id_cols}.

This is similar to grouping by the \code{id_cols} then summarizing the
unused columns using \code{unused_fn}.}
}
\value{
\code{tidySummarizedExperiment}
}
\description{
\code{pivot_wider()} "widens" data, increasing the number of columns and
decreasing the number of rows. The inverse transformation is
\code{\link[tidyr:pivot_longer]{pivot_longer()}}.

Learn more in \code{vignette("pivot")}.
}
\details{
\code{pivot_wider()} is an updated approach to \code{\link[tidyr:spread]{spread()}}, designed to be both
simpler to use and to handle more use cases. We recommend you use
\code{pivot_wider()} for new code; \code{spread()} isn't going away but is no longer
under active development.
}
\examples{
# See vignette("pivot") for examples and explanation
library(dplyr)
tidySummarizedExperiment::pasilla \%>\%
    pivot_wider(names_from=feature, values_from=counts)

}
\references{
Hutchison, W.J., Keyes, T.J., The tidyomics Consortium. et al. The tidyomics ecosystem: enhancing omic data analyses. Nat Methods 21, 1166–1170 (2024). https://doi.org/10.1038/s41592-024-02299-2

Wickham, H., Vaughan, D. (2023). tidyr: Tidy Messy Data. R package version 2.0.0, https://CRAN.R-project.org/package=tidyr
}
\seealso{
\code{\link[tidyr:pivot_wider_spec]{pivot_wider_spec()}} to pivot "by hand" with a data frame that
defines a pivoting specification.
}
