% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{gate}
\alias{gate}
\title{Interactively gate cells by spatial coordinates}
\usage{
gate(
  spe,
  image_index = 1,
  colour = NULL,
  shape = NULL,
  alpha = 1,
  size = 2,
  hide_points = FALSE,
  programmatic_gates = NULL
)
}
\arguments{
\item{spe}{A SpatialExperiment object.}

\item{image_index}{The image to display if multiple are stored within the provided
SpatialExperiment object.}

\item{colour}{A single colour string compatible with ggplot2. Or, a vector representing the
point colour.}

\item{shape}{A single ggplot2 shape numeric ranging from 0 to 127. Or, a vector representing the
point shape, coercible to a factor of 6 or less levels.}

\item{alpha}{A single ggplot2 alpha numeric ranging from 0 to 1.}

\item{size}{A single ggplot2 size numeric ranging from 0 to 20.}

\item{hide_points}{A logical. If TRUE, points are hidden during interactive gating. This can
greatly improve performance with large SpatialExperiment objects.}

\item{programmatic_gates}{A \code{data.frame} of the gate brush data, as saved in
\code{tidygate_env$gates}. The column \code{x} records X coordinates, the column \code{y} records Y coordinates
and the column \code{.gate} records the gate number. When this argument is supplied, gates will be
drawn programmatically.}
}
\value{
A vector of strings, of the gates each X and Y coordinate pair is within. If gates are
drawn interactively, they are temporarily saved to \code{tidygate_env$gates}.
}
\description{
Gate cells based on their X and Y coordinates. By default, this function launches an interactive
scatter plot with image data overlaid. Colour, shape, size and alpha can be defined as constant
values, or can be controlled by the values of a specified column.

If previously drawn gates are supplied to the \code{programmatic_gates} argument, cells will be gated
programmatically. This feature allows the reproduction of previously drawn interactive gates.
Programmatic gating is based on the package gatepoints by Wajid Jawaid.
}
\examples{
example(read10xVisium)
data(demo_brush_data, package = "tidySpatialExperiment")

# Gate points interactively
if(interactive()) {
    spe |>
        gate(colour = "blue", shape = "in_tissue")
}

# Gate points programmatically
spe |>
  gate(programmatic_gates = demo_brush_data)
}
