% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclustplot.R
\name{hclustplot}
\alias{hclustplot}
\title{Hierarchical Clustering Dendrogram (hclustplot)}
\usage{
hclustplot(
  exploredds,
  method = "spearman",
  plotly = FALSE,
  savePlot = FALSE,
  filePlot = NULL
)
}
\arguments{
\item{exploredds}{object of class \code{\link[DESeq2:DESeqTransform]{DESeq2::DESeqTransform()}}.}

\item{method}{a \verb{character string} indicating which correlation coefficient
is to be computed, based on the \code{\link[stats:cor]{stats::cor()}} function. Options are:
c("pearson" "kendall", "spearman").}

\item{plotly}{logical: when \code{FALSE} (default), the \code{ggplot2} plot will be
returned. \code{TRUE} option returns the \code{plotly} version of the plot.}

\item{savePlot}{logical: when \code{FALSE} (default), the plot will not be saved.
If \code{TRUE} the plot will be saved, and requires the \code{filePlot} argument.}

\item{filePlot}{file name where the plot will be saved. For more information,
please consult the \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} function.}
}
\value{
returns an object of \code{ggplot} or \code{plotly} class.
}
\description{
This function computes the sample-wise correlation coefficients
using the \code{\link[stats:cor]{stats::cor()}} function from the transformed expression values.
After transformation to a distance matrix, hierarchical clustering is
performed with the \code{\link[stats:hclust]{stats::hclust()}} function, and the result is plotted as
a dendrogram.
}
\examples{
## Targets file
targetspath <- system.file("extdata", "targets.txt", 
package = "systemPipeR")
targets <- read.delim(targetspath, comment = "#")
cmp <- systemPipeR::readComp(file = targetspath, 
format = "matrix", delim = "-")
## Count table file
countMatrixPath <- system.file("extdata", "countDFeByg.xls",
 package = "systemPipeR")
countMatrix <- read.delim(countMatrixPath, row.names = 1)
## Plot
exploredds <- exploreDDS(countMatrix, targets,
    cmp = cmp[[1]],
    preFilter = NULL, transformationMethod = "rlog"
)
hclustplot(exploredds, method = "spearman")
}
\keyword{visualization}
