% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_synteny_detection.R
\name{infer_syntenet}
\alias{infer_syntenet}
\title{Infer synteny network}
\usage{
infer_syntenet(
  blast_list = NULL,
  annotation = NULL,
  outdir = tempdir(),
  anchors = 5,
  max_gaps = 25,
  is_pairwise = TRUE,
  verbose = FALSE,
  bp_param = BiocParallel::SerialParam(),
  ...
)
}
\arguments{
\item{blast_list}{A list of data frames, each data frame having
the tabular output of BLASTp or similar programs, such as DIAMOND.
This is the output of the function \code{run_diamond()}. If you performed
pairwise comparisons on the command line, you can read the tabular output
as data frames and combine them in a list. List names must be have species
names separated by underscore. For instance, if the first list element is
a data frame containing the comparison of speciesA (query)
against speciesB (database), its name must be "speciesA_speciesB".}

\item{annotation}{A processed GRangesList, CompressedGRangesList, or
list of GRanges as returned by \code{process_input()}.}

\item{outdir}{Path to the output directory. Default: tempdir().}

\item{anchors}{Numeric indicating the minimum required number of genes
to call a syntenic block. Default: 5.}

\item{max_gaps}{Numeric indicating the number of upstream and downstream
genes to search for anchors. Default: 25.}

\item{is_pairwise}{specify if only pairwise blocks should be reported
Default: TRUE}

\item{verbose}{Logical indicating if log messages should be printed on
screen. Default: FALSE.}

\item{bp_param}{BiocParallel back-end to be used.
Default: \code{BiocParallel::SerialParam()}.}

\item{...}{Any additional arguments to the \code{MCScanX} algorithm. For a
complete list of all available options, see the man page
of \code{rcpp_mcscanx_file()}.}
}
\value{
A network represented as an edge list.
}
\description{
Infer synteny network
}
\examples{
# Load data
data(proteomes)
data(annotation)
data(blast_list)

# Create processed annotation list
annotation <- process_input(proteomes, annotation)$annotation

# Infer the synteny network
net <- infer_syntenet(blast_list, annotation)
}
