% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_species_id_table}
\alias{create_species_id_table}
\title{Create a data frame of species IDs (3-5-character abbreviations)}
\usage{
create_species_id_table(species_names)
}
\arguments{
\item{species_names}{A character vector of names extracted from
the \strong{seq} or \strong{annotation} lists, which can be extracted with
\code{names(seq)} or \code{names(annotation)}.}
}
\value{
A 2-column data frame with the following variables:
\describe{
\item{species_id}{Character, species ID consisting of 3-5 characters.}
\item{species_name}{Character, original names passed as input.}
}
}
\description{
Create a data frame of species IDs (3-5-character abbreviations)
}
\examples{
# Load 'seq' list (list of AAStringSet objects)
data(proteomes)

# Create ID table
create_species_id_table(names(proteomes))
}
