% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{save_cache}
\alias{save_cache}
\title{Save R Objects in Cache}
\usage{
save_cache(dir = NULL, overwrite = TRUE, obj, na = NULL)
}
\arguments{
\item{dir}{The directory path to save the cached data. Default is NULL and the cached data is stored in \code{~/.cache/shm}.}

\item{overwrite}{Logical, TRUE or FALSE. Default is TRUE and data in the cache with the same name of the object in \code{...} will be overwritten.}

\item{obj, na}{A single R object (`obj`) to be cached into the file named `na`.}
}
\value{
The directory path of the cache.
}
\description{
Save R Objects in Cache
}
\examples{
# Save the object "iris" in the default cache "~/.cache/shm".
cache.pa <- save_cache(dir=NULL, overwrite=TRUE, iris)
}
\references{
Lori Shepherd and Martin Morgan (2020). BiocFileCache: Manage Files Across Sessions. R package version 1.12.1.
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
