% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svg_methods.R
\docType{methods}
\name{SVGMethods}
\alias{SVGMethods}
\alias{coordinate}
\alias{coordinate<-}
\alias{attribute}
\alias{attribute<-}
\alias{dimension}
\alias{dimension<-}
\alias{svg_obj}
\alias{svg_obj<-}
\alias{raster_pa}
\alias{raster_pa<-}
\alias{cmb}
\alias{names}
\alias{names<-,SVG-method}
\alias{sub_sf}
\alias{angle}
\alias{angle<-}
\alias{coordinate,SVG-method}
\alias{coordinate<-,SVG-method}
\alias{attribute,SVG-method}
\alias{attribute<-,SVG-method}
\alias{dimension,SVG-method}
\alias{dimension<-,SVG-method}
\alias{raster_pa,SVG-method}
\alias{raster_pa<-,SVG-method}
\alias{svg_obj,SVG-method}
\alias{svg_obj<-,SVG-method}
\alias{angle,SVG-method}
\alias{angle<-,SVG-method}
\alias{[,SVG,ANY,ANY,ANY-method}
\alias{[<-,SVG,ANY,ANY,ANY-method}
\alias{length,SVG-method}
\alias{names,SVG-method}
\alias{cmb,SVG,SVG-method}
\alias{sub_sf,SVG-method}
\title{Methods for S4 class \code{SVG}}
\usage{
\S4method{coordinate}{SVG}(x)

\S4method{coordinate}{SVG}(x) <- value

\S4method{attribute}{SVG}(x)

\S4method{attribute}{SVG}(x) <- value

\S4method{dimension}{SVG}(x)

\S4method{dimension}{SVG}(x) <- value

\S4method{raster_pa}{SVG}(x)

\S4method{raster_pa}{SVG}(x) <- value

\S4method{svg_obj}{SVG}(x)

\S4method{svg_obj}{SVG}(x) <- value

\S4method{angle}{SVG}(x)

\S4method{angle}{SVG}(x) <- value

\S4method{[}{SVG,ANY,ANY,ANY}(x, i, j)

\S4method{[}{SVG,ANY,ANY,ANY}(x, i) <- value

\S4method{length}{SVG}(x)

\S4method{names}{SVG}(x)

\S4method{names}{SVG}(x) <- value

\S4method{cmb}{SVG,SVG}(x, y)

\S4method{sub_sf}{SVG}(svg, show = NULL, hide = NULL)
}
\arguments{
\item{x, y}{Two \code{SVG} objects.}

\item{value}{A value for replacement.}

\item{i, j}{Two integers specifying an aSVG instance and a slot of the same aSVG respectively.}

\item{svg}{An \code{SVG} object.}

\item{show, hide}{Two vectors of indexes in the \code{attribute} slot. aSVG features corresponding to these indexes will be shown or hidden in spatial heatmap plots respectively.}
}
\value{
An object of \code{SVG}, \code{data.frame}, or \code{numeric}.
}
\description{
These are methods for subsetting, getting, setting, or combining \linkS4class{SVG} objects.
}
\section{Main methods}{

In the following code snippets, \code{cordn} is a \linkS4class{SVG} object.
\describe{
\item{\code{cordn[i]}, \code{cordn[i, ]}}{
  Subsetting the ith aSVG instance.
}
\item{\code{cordn[i] <- cordn.new}}{
  Replacing the ith aSVG instance in \code{cordn} with a new \code{cordn} object \code{cordn.new}.
}
\item{\code{cordn[, j]}}{
  Subsetting the jth slot of all aSVG instances.
}
\item{\code{cordn[, 'coordinate']}, \code{coordinate(cordn)}}{
  Subsetting the \code{coordinate} slot that contains coordinates of all aSVG instances.
}
\item{\code{length(cordn)}}{
  Number of all aSVG instances.
}
\item{\code{names(cordn)}, \code{names(cordn)[1] <- 'newName'}}{
  Names of all aSVG instances, rename the first aSVG instance.
}
\item{\code{cbm(cordn1, cordn2)}}{
  Combining two aSVG instances.
}
}
}

\examples{

# Create the first aSVG instance. 
svg.pa1 <- system.file('extdata/shinyApp/data/maize_leaf_shm1.svg',
package='spatialHeatmap')
svg1 <- read_svg(svg.path=c(svg.pa1)); names(svg1); length(svg1); slotNames(svg1)
# Create the second aSVG instance. 
svg.pa2 <- system.file('extdata/shinyApp/data/maize_leaf_shm2.svg',
package='spatialHeatmap')
svg2 <- read_svg(svg.path=c(svg.pa2)); names(svg2); length(svg2)
# Combine these two instances.
svg3 <- cmb(svg1, svg2); names(svg3); length(svg3)
# The first aSVG instance
svg3[1]
# Coordinates of the first aSVG instance 
svg3[, 'coordinate'][1]; coordinate(svg3)[1]
# Extract slots from "svg3" into a list and create a new "SVG" object.
lis <- list(cordn=coordinate(svg3), attrb=attribute(svg3), svg=svg_obj(svg3))
new.svgs <- SVG(coordinate=lis$cordn, attribute=lis$attrb, svg=lis$svg)
# Change aSVG instance names.
names(new.svgs) <- c('aSVG1', 'aSVG2'); names(new.svgs)
# Replace the second instance in "svg3".
svg3[2] <- new.svgs[2]
# Replace a slot content.
coordinate(svg3)[[1]] <- coordinate(new.svgs)[[1]]
}
\references{
Wickham H, François R, Henry L, Müller K (2022). _dplyr: A Grammar of Data Manipulation_. R package version 1.0.9, <https://    CRAN.R-project.org/package=dplyr>

Wickham H, François R, Henry L, Müller K (2022). _dplyr: A Grammar of Data Manipulation_. R package version 1.0.9, <https://CRAN.R-project.org/package=dplyr>
}
\seealso{
\code{\link{SVG}}: creating \code{SVG} objects.
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
