% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_k.R
\name{optimal_k}
\alias{optimal_k}
\title{Using the elbow method to find the optimal number of clusters in K-means clustering}
\usage{
optimal_k(data, max.k, title = "Elbow Method for Finding the Optimal k")
}
\arguments{
\item{data}{A numeric \code{data.frame} scaled with \code{scale}.}

\item{max.k}{The max number of clusters to consider.}

\item{title}{A character string of the elbow plot title.}
}
\value{
A ggplot.
}
\description{
This function is designed to find the optimal number of clusters in K-means clustering using the elbow method.
}
\examples{
data <- iris[, 1:4]
dat.scl <- scale(data)
optimal_k(dat.scl, 5)
}
\references{
H. Wickham. ggplot2: Elegant Graphics for Data Analysis. Springer-Verlag New York, 2016.
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
