% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/svg.R
\docType{class}
\name{SVG-class}
\alias{SVG-class}
\alias{SVG}
\title{The SVG class for storing annotated SVG (aSVG) instances}
\usage{
SVG(
  coordinate = list(),
  attribute = list(),
  dimension = list(),
  svg = list(),
  raster = list(),
  angle = list()
)
}
\arguments{
\item{coordinate}{A named \code{list} of x-y coordinates parsed from one or multile aSVG files respectively. Coordinates are represented in three columns \code{x}, \code{y}, and \code{feature} in form of \code{data.frame} or \code{tbl}, corresponding to x, y coordinates, and spatial features (cellular compartments, tissues, organs, etc.) in aSVGs respectively. The \code{list} name slots refer to aSVG instances respectively, e.g. list(SVGInstance1=coordinate1, SVGInstance2=coordinate2).}

\item{attribute}{A named \code{list} of attributes of coordinates in \code{coordinate}. Attributes are represented in at least four columns \code{feature}, \code{id}, \code{fill} and \code{stroke} in form of \code{data.frame} or \code{tbl}, corresponding to \code{feature} in \code{coordinate}, ids of \code{feature}, fill colors of \code{feature}, and line widths of \code{feature} respectively. \code{id} can be the same as \code{feature} or ontology ids. The \code{list} name slots refer to aSVG instances respectively and must match those in \code{coordinate}, e.g. list(SVGInstance1=attribute1, SVGInstance2=attribute2).}

\item{dimension}{A named \code{list} of width/height parsed from one or multile aSVG files respectively, which is calculated from \code{coordinate} automatically. Each pair of width/height is stored in a named vector. The \code{list} name slots refer to aSVG instances respectively and must match those in \code{coordinate}, e.g. list(SVGInstance1=c(with=100, height=8), SVGInstance2=c(with=20, height=15)).}

\item{svg}{A named \code{list} of one or multile aSVG instances, each in form of an `raw` object returned by \code{\link[xml2]{xml_serialize}}. The \code{list} name slots refer to aSVG files respectively and must match those in \code{coordinate}, e.g. list(SVGInstance1=svg1, SVGInstance2=svg2).}

\item{raster}{A named \code{list} of directory path(s) of one or multile raster image files (jpg, png) respectively. This argument is relevant only when superimposing raster images with spatial heatmap plots that are created from aSVG images. The default is \code{NULL} for each aSVG instance. aSVG images are usually created by using these raster images as templates, otherwise spatial features between the two will not match. The \code{list} name slots refer to aSVG instances respectively and must match those in \code{coordinate}, e.g. list(SVGInstance1=raster.path1, SVGInstance2=raster.path2).}

\item{angle}{Applicable in the case of spatially resolved single-cell data. A named \code{list} of one or multiple rotation degrees of the shapes with the identifier `overlay` in one or muptiple aSVGs respectively. The \code{list} name slots refer to aSVG instances respectively and must be the same with \code{coordinate}, e.g. list(SVGInstance1=90, SVGInstance2=45).}
}
\value{
A SVG object.
}
\description{
The SVG class is designed to represent annotated SVG (aSVG) instances.
}
\examples{

# The first raste image used as a template to create an aSVG. 
raster.pa1 <- system.file('extdata/shinyApp/data/maize_leaf_shm1.png',
package='spatialHeatmap')
# The first aSVG created with the first template. 
svg.pa1 <- system.file('extdata/shinyApp/data/maize_leaf_shm1.svg',
package='spatialHeatmap')
# The second raster image used as a template to create an aSVG. 
raster.pa2 <- system.file('extdata/shinyApp/data/maize_leaf_shm2.png',
package='spatialHeatmap')
# The second aSVG created with the second template. 
svg.pa2 <- system.file('extdata/shinyApp/data/maize_leaf_shm2.svg',
package='spatialHeatmap')

# Parse these two aSVGs without association with raster images.
svgs <- read_svg(svg.path=c(svg.pa1, svg.pa2), raster.path=NULL)

# Parse these two aSVGs. The raster image paths are provide so as to 
# be associated with respective aSVGs, which will be used when 
# superimposing raster images with SHM plots.
svgs <- read_svg(svg.path=c(svg.pa1, svg.pa2), raster.path=c(raster.pa1, raster.pa2))

# Two aSVG instances are stored in a "SVG" object of "svgs".
names(svgs)
# Access content of "svgs".
svgs[1, ] # The first aSVG instance
svgs[, 'coordinate'][1]; coordinate(svgs)[1] # The coordinates of the first aSVG instance
# Combine two "SVG" objects.
x <- svgs[1, ]; y <- svgs[2, ]; cmb(x, y)
# Extract slots from "svgs" and create a new "SVG" object.
lis <- list(cordn=coordinate(svgs), attrb=attribute(svgs), svg=svg_obj(svgs), raster=raster_pa(svgs))
new.svgs <- SVG(coordinate=lis$cordn, attribute=lis$attrb, svg=lis$svg, raster=lis$raster)
# Change aSVG instance names.
names(new.svgs) <- c('aSVG1', 'aSVG2')
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
