% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_markers.R
\name{markers_mclust}
\alias{markers_mclust}
\title{select markers using mclust EM method}
\usage{
markers_mclust(
  top_markers,
  column = ".dot",
  prob = 0.99,
  s_thres = NULL,
  method = c("max.one", "remove.min"),
  plot = FALSE,
  ...
)
}
\arguments{
\item{top_markers}{output of \code{\link[=top_markers]{top_markers()}}}

\item{column}{character, specify which column used as group label}

\item{prob}{numeric, probability cutoff for 1st component classification}

\item{s_thres}{NULL or numeric, only features with score > threshold will be
returned, if NULL will use 2 * average probability as threshold}

\item{method}{can be "max.one" or "remove.min", if to only keep features in
1st component or return features not in the last component}

\item{plot}{logical, if to plot mixture density and hist}

\item{...}{other params for \code{\link[mclust:densityMclust]{mclust::densityMclust()}}}
}
\value{
a list of markers for each group
}
\description{
select markers using mclust EM method
}
\examples{
data <- matrix(rnorm(100), 10, dimnames = list(1:10))
top_n <- top_markers(data, label = rep(c("A", "B"), 5))
markers_mclust(top_n)
}
