% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMutSites.R
\name{plotMutSites}
\alias{plotMutSites}
\alias{plotMutSites.SNPsites}
\alias{plotMutSites.lineagePath}
\alias{plotMutSites.parallelSites}
\alias{plotMutSites.fixationSites}
\alias{plotMutSites.paraFixSites}
\title{Plot tree and mutation sites}
\usage{
plotMutSites(x, ...)

\method{plotMutSites}{SNPsites}(x, showTips = FALSE, ...)

\method{plotMutSites}{lineagePath}(x, ...)

\method{plotMutSites}{parallelSites}(x, ...)

\method{plotMutSites}{fixationSites}(x, ...)

\method{plotMutSites}{paraFixSites}(
  x,
  widthRatio = 0.75,
  fontSize = 3.88,
  dotSize = 1,
  lineSize = 0.5,
  ...
)
}
\arguments{
\item{x}{An \code{\link{SNPsites}} object.}

\item{...}{Other arguments}

\item{showTips}{Whether to plot the tip labels. The default is \code{FALSE}.}

\item{widthRatio}{The width ratio between tree plot and SNP plot}

\item{fontSize}{The font size of the mutation label in tree plot}

\item{dotSize}{The dot size of SNP in SNP plot}

\item{lineSize}{The background line size in SNP plot}
}
\value{
A tree plot with SNP as dots for each tip.
}
\description{
The mutated sites for each tip in a phylogenetic tree will be
  represented as colored dots positioned by their site number.
}
\examples{
data(zikv_tree_reduced)
data(zikv_align_reduced)
tree <- addMSA(zikv_tree_reduced, alignment = zikv_align_reduced)
plotMutSites(SNPsites(tree))
}
