% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.R
\name{as.data.frame.fixationSites}
\alias{as.data.frame.fixationSites}
\alias{as.data.frame.SNPsites}
\alias{as.data.frame.parallelSites}
\title{Convert results to Data Frame}
\usage{
\method{as.data.frame}{fixationSites}(x, row.names = NULL, optional = FALSE, ...)

\method{as.data.frame}{SNPsites}(x, row.names = NULL, optional = FALSE, ...)

\method{as.data.frame}{parallelSites}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{The object to be converted to \code{data.frame}.}

\item{row.names}{Unimplemented.}

\item{optional}{Unimplemented.}

\item{...}{Other arguments.}
}
\value{
A \code{\link{data.frame}} object.
}
\description{
Convert return of functions in \code{sitePath} package to a
  \code{\link{data.frame}} so can be better worked with. The group name for
  each tip is the same as \code{\link{groupTips}}.

A \code{\link{fixationSites}} object will output the mutation
  name of the fixation and the cluster name before and after the mutation.

An \code{\link{SNPsites}} object will output the tip name with
  the SNP and its position.

An \code{\link{parallelSites}} object will output the tip name
  with the group name and mutation info.
}
\examples{
data(zikv_tree_reduced)
data(zikv_align_reduced)
tree <- addMSA(zikv_tree_reduced, alignment = zikv_align_reduced)
fixations <- fixationSites(lineagePath(tree))
as.data.frame(fixations)
}
