% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addMSA.R
\name{phyMSAmatched}
\alias{phyMSAmatched}
\alias{addMSA}
\alias{addMSA.phylo}
\alias{addMSA.treedata}
\title{Add matching sequence alignment to the tree}
\usage{
addMSA(tree, ...)

\method{addMSA}{phylo}(
  tree,
  msaPath = "",
  msaFormat = c("fasta", "clustal", "phylip", "mase", "msf"),
  alignment = NULL,
  seqType = c("AA", "DNA", "RNA"),
  ...
)

\method{addMSA}{treedata}(tree, ...)
}
\arguments{
\item{tree}{A \code{\link{phylo}} object. This commonly can be from tree
parsing function in \code{\link{ape}} or \code{\link{ggtree}}. All the
\code{tip.label} should be found in the sequence alignment. The tree is
supposed to be fully resolved (bifurcated) and will be resolved by
\code{\link{multi2di}} if \code{\link{is.binary}} gives \code{FALSE}.}

\item{...}{Other arguments.}

\item{msaPath}{The file path to the multiple sequence alignment file.}

\item{msaFormat}{The format of the multiple sequence alignment file. The
internal uses the \code{\link{read.alignment}} from \code{\link{seqinr}}
package to parse the sequence alignment. The default is "fasta" and it also
accepts "clustal", "phylip", "mase", "msf".}

\item{alignment}{An \code{alignment} object. This commonly can be from
sequence parsing function in the \code{\link{seqinr}} package. Sequence
names in the alignment should include all \code{tip.label} in the tree}

\item{seqType}{The type of the sequence in the alignment file. The default is
"AA" for amino acid. The other options are "DNA" and "RNA".}
}
\value{
Since 1.5.12, the function returns a \code{phyMSAmatched} object to
  avoid S3 methods used on \code{phylo} (better encapsulation).
}
\description{
\code{addMSA} wraps \code{\link{read.alignment}} function in
  \code{\link{seqinr}} package and helps match names in tree and sequence
  alignment. Either provide the file path to an alignment file and its format
  or an alignment object from the return of \code{\link{read.alignment}}
  function. If both the file path and alignment object are given, the
  function will use the sequence in the alignment file.
}
\examples{
data(zikv_tree)
msaPath <- system.file('extdata', 'ZIKV.fasta', package = 'sitePath')
addMSA(zikv_tree, msaPath = msaPath, msaFormat = 'fasta')
}
\seealso{
\code{\link{read.alignment}}
}
