% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNPsites.R
\name{SNPsites}
\alias{SNPsites}
\alias{SNPsites.phyMSAmatched}
\title{Finding sites with variation}
\usage{
SNPsites(tree, ...)

\method{SNPsites}{phyMSAmatched}(tree, minSNP = NULL, ...)
}
\arguments{
\item{tree}{A \code{\link{phyMSAmatched}} object.}

\item{...}{Other arguments}

\item{minSNP}{Minimum number of a mutation to be a SNP. The default is 10th
of the total tree tips.}
}
\value{
A \code{SNPsites} object.
}
\description{
Single nucleotide polymorphism (SNP) in the whole package refers
  to variation of amino acid. \code{SNPsite} will try to find SNP in the
  multiple sequence alignment. A reference sequence and gap character may be
  specified to number the site.
}
\examples{
data(zikv_tree_reduced)
data(zikv_align_reduced)
tree <- addMSA(zikv_tree_reduced, alignment = zikv_align_reduced)
SNPsites(tree)
}
