% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sctkQCUtils.R
\name{qcInputProcess}
\alias{qcInputProcess}
\title{Create SingleCellExperiment object from command line input arguments}
\usage{
qcInputProcess(
  preproc,
  samplename,
  path,
  raw,
  fil,
  ref,
  rawFile,
  filFile,
  flatFiles,
  dataType
)
}
\arguments{
\item{preproc}{Method used to preprocess the data. It's one of the path provided in --preproc argument.}

\item{samplename}{The sample name of the data. It's one of the path provided in --sample argument.}

\item{path}{Base path of the dataset. It's one of the path provided in --bash_path argument.}

\item{raw}{The directory contains droplet matrix, gene and cell barcodes information. It's one of the path provided in --raw_data_path argument.}

\item{fil}{The directory contains cell matrix, gene and cell barcodes information. It's one of the path provided in --cell_data_path argument.}

\item{ref}{The name of reference used by cellranger. Only need for CellrangerV2 data.}

\item{rawFile}{The full path of the RDS file or Matrix file of the raw gene count matrix. It's one of the path provided in --raw_data argument.}

\item{filFile}{The full path of the RDS file or Matrix file of the cell count matrix. It's one of the path provided in --cell_data argument.}

\item{flatFiles}{The full paths of the matrix, barcode, and features (in that order) files used to construct an SCE object.}

\item{dataType}{Type of the input. It can be "Both", "Droplet" or "Cell". It's one of the path provided in --genome argument.}
}
\value{
A list of \link[SingleCellExperiment]{SingleCellExperiment} object containing
the droplet or cell data or both,depending on the dataType that users provided.
}
\description{
Create SingleCellExperiment object from command line input arguments
}
