% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importGeneSets.R
\name{importMitoGeneSet}
\alias{importMitoGeneSet}
\title{Import mitochondrial gene sets}
\usage{
importMitoGeneSet(
  inSCE,
  reference = "human",
  id = "ensembl",
  by = "rownames",
  collectionName = "mito",
  noMatchError = TRUE
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{reference}{Character. Species available are "human" and "mouse".}

\item{id}{Types of gene id. Now it supports "symbol", "entrez", "ensembl"
and "ensemblTranscriptID".}

\item{by}{Character. Describes the location within \code{inSCE} where the gene
identifiers in the mitochondrial gene sets should be mapped.
If set to \code{"rownames"} then the features will
be searched for among \code{rownames(inSCE)}. This can also be
set to one of the column names of \code{rowData(inSCE)} in which case the
gene identifies will be mapped to that column in the \code{rowData}
of \code{inSCE}. See \link{featureIndex} for more information.
Default \code{"rownames"}.}

\item{collectionName}{Character. Name of collection to add gene sets to.
If this collection already exists in \code{inSCE}, then these gene sets will
be added to that collection. Any gene sets within the collection with the
same name will be overwritten. Default \code{"mito"}.}

\item{noMatchError}{Boolean. Show an error if a collection does not have
any matching features. Default \code{TRUE}.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object
with gene set from \code{collectionName} output stored to the
\link{metadata} slot.
}
\description{
Imports mitochondrial gene sets and  stores it in the metadata of the
\linkS4class{SingleCellExperiment} object. These gene sets can be used in
downstream quality control and analysis functions in \link{singleCellTK}.
}
\details{
The gene identifiers of mitochondrial genes will be loaded with
"data(AllMito)". Currently, it supports human and mouse references.
Also, it supports entrez ID, gene symbol, ensemble ID and ensemble transcript ID.
They will be mapped to the IDs in \code{inSCE} using the \code{by} parameter and
stored in a \linkS4class{GeneSetCollection} object from package
\link{GSEABase}. This object is stored in
\code{metadata(inSCE)$sctk$genesets}, which can be accessed in downstream
analysis functions such as \link[singleCellTK]{runCellQC}.
}
\examples{
data(scExample)
sce <- importMitoGeneSet(inSCE = sce,
                         reference = "human",
                         id = "ensembl",
                         collectionName = "human_mito",
                         by = "rownames")
}
\seealso{
\link{importGeneSetsFromList} for importing from lists,
\link{importGeneSetsFromGMT} for importing from GMT files, and
\linkS4class{GeneSetCollection} objects.
}
\author{
Rui Hong
}
