% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sctkTagging.R
\name{expData<-}
\alias{expData<-}
\title{expData
Store data items using tags to identify the type of data item stored. To be used as a replacement for assay<- setter function but with additional parameter to set a tag to a data item.}
\usage{
expData(inSCE, assayName, tag = NULL, altExp = FALSE) <- value
}
\arguments{
\item{inSCE}{Input \code{SingleCellExperiment} object.}

\item{assayName}{Specify the name of the input assay.}

\item{tag}{Specify the tag to store against the input assay. Default is \code{NULL}, which will set the tag to "uncategorized".}

\item{altExp}{A \code{logical} value indicating if the input assay is a \code{altExp} or a subset assay.}

\item{value}{An input matrix-like value to store in the SCE object.}
}
\value{
A \code{SingleCellExperiment} object containing the newly stored data.
}
\description{
expData
Store data items using tags to identify the type of data item stored. To be used as a replacement for assay<- setter function but with additional parameter to set a tag to a data item.
}
\examples{
data(scExample, package = "singleCellTK")
mat <- expData(sce, "counts")
expData(sce, "counts", tag = "raw") <- mat
}
