% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{cluster_terms}
\alias{cluster_terms}
\alias{cluster_by_kmeans}
\alias{cluster_by_pam}
\alias{cluster_by_dynamicTreeCut}
\alias{cluster_by_fast_greedy}
\alias{cluster_by_leading_eigen}
\alias{cluster_by_louvain}
\alias{cluster_by_walktrap}
\alias{cluster_by_mclust}
\alias{cluster_by_apcluster}
\alias{cluster_by_hdbscan}
\alias{cluster_by_MCL}
\title{Cluster terms based on their similarity matrix}
\usage{
cluster_terms(
  mat,
  method = "binary_cut",
  control = list(),
  verbose = se_opt$verbose
)

cluster_by_kmeans(mat, max_k = max(2, min(round(nrow(mat)/5), 100)), ...)

cluster_by_pam(mat, max_k = max(2, min(round(nrow(mat)/10), 100)), ...)

cluster_by_dynamicTreeCut(mat, minClusterSize = 5, ...)

cluster_by_fast_greedy(mat, ...)

cluster_by_leading_eigen(mat, ...)

cluster_by_louvain(mat, ...)

cluster_by_walktrap(mat, ...)

cluster_by_mclust(mat, G = seq_len(max(2, min(round(nrow(mat)/5), 100))), ...)

cluster_by_apcluster(mat, s = apcluster::negDistMat(r = 2), ...)

cluster_by_hdbscan(mat, minPts = 5, ...)

cluster_by_MCL(mat, addLoops = TRUE, ...)
}
\arguments{
\item{mat}{A similarity matrix.}

\item{method}{The clustering methods. Value should be in \code{\link[=all_clustering_methods]{all_clustering_methods()}}.}

\item{control}{A list of parameters passed to the corresponding clustering function.}

\item{verbose}{Whether to print messages.}

\item{max_k}{Maximal \emph{k} for k-means/PAM clustering. K-means/PAM clustering is applied from k = 2 to k = max_k.}

\item{...}{Other arguments.}

\item{minClusterSize}{Minimal number of objects in a cluster. Pass to \code{\link[dynamicTreeCut:cutreeDynamic]{dynamicTreeCut::cutreeDynamic()}}.}

\item{G}{Passed to the \code{G} argument in \code{\link[mclust:Mclust]{mclust::Mclust()}} which is the number of clusters.}

\item{s}{Passed to the \code{s} argument in \code{\link[apcluster:apcluster-methods]{apcluster::apcluster()}}.}

\item{minPts}{Passed to the \code{minPts} argument in \code{\link[dbscan:hdbscan]{dbscan::hdbscan()}}.}

\item{addLoops}{Passed to the \code{addLoops} argument in \code{\link[MCL:mcl]{MCL::mcl()}}.}
}
\value{
A vector of numeric cluster labels.
}
\description{
Cluster terms based on their similarity matrix
}
\details{
New clustering methods can be registered by \code{\link[=register_clustering_methods]{register_clustering_methods()}}.

Please note it is better to directly use \code{cluster_terms()} for clustering while not the individual \verb{cluster_by_*} functions
because \code{cluster_terms()} does additional cluster label adjustment.

By default, there are the following clustering methods and corresponding clustering functions:
\itemize{
\item \code{kmeans} see \code{\link[=cluster_by_kmeans]{cluster_by_kmeans()}}.
\item \code{dynamicTreeCut} see \code{\link[=cluster_by_dynamicTreeCut]{cluster_by_dynamicTreeCut()}}.
\item \code{mclust} see \code{\link[=cluster_by_mclust]{cluster_by_mclust()}}.
\item \code{apcluster} see \code{\link[=cluster_by_apcluster]{cluster_by_apcluster()}}.
\item \code{hdbscan} see \code{\link[=cluster_by_hdbscan]{cluster_by_hdbscan()}}.
\item \code{fast_greedy} see \code{\link[=cluster_by_fast_greedy]{cluster_by_fast_greedy()}}.
\item \code{louvain} see \code{\link[=cluster_by_louvain]{cluster_by_louvain()}}.
\item \code{walktrap} see \code{\link[=cluster_by_walktrap]{cluster_by_walktrap()}}.
\item \code{MCL} see \code{\link[=cluster_by_MCL]{cluster_by_MCL()}}.
\item \code{binary_cut} see \code{\link[=binary_cut]{binary_cut()}}.
}

The additional argument in individual clustering functions can be set with the \code{control} argument
in \code{cluster_terms()}.

\code{cluster_by_kmeans()}: The best k for k-means clustering is determined according to the "elbow" or "knee" method on
the distribution of within-cluster sum of squares (WSS) on each k. All other arguments are passed
from \code{...} to \code{\link[stats:kmeans]{stats::kmeans()}}.

\code{cluster_by_pam()}: PAM is applied by \code{\link[fpc:pamk]{fpc::pamk()}} which can automatically select the best k.
All other arguments are passed from \code{...} to \code{\link[fpc:pamk]{fpc::pamk()}}.

\code{cluster_by_dynamicTreeCut()}: All other arguments are passed from \code{...} to \code{\link[dynamicTreeCut:cutreeDynamic]{dynamicTreeCut::cutreeDynamic()}}.

\code{cluster_by_fast_greedy()}: All other arguments are passed from \code{...} to \code{\link[igraph:cluster_fast_greedy]{igraph::cluster_fast_greedy()}}.

\code{cluster_by_leading_eigen()}: All other arguments are passed from \code{...} to \code{\link[igraph:cluster_leading_eigen]{igraph::cluster_leading_eigen()}}.

\code{cluster_by_louvain()}: All other arguments are passed from \code{...} to \code{\link[igraph:cluster_louvain]{igraph::cluster_louvain()}}.

\code{cluster_by_walktrap()}: All other arguments are passed from \code{...} to \code{\link[igraph:cluster_walktrap]{igraph::cluster_walktrap()}}.

\code{cluster_by_mclust()}: All other arguments are passed from \code{...} to \code{\link[mclust:Mclust]{mclust::Mclust()}}.

\code{cluster_by_apcluster()}: All other arguments are passed from \code{...} to \code{\link[apcluster:apcluster-methods]{apcluster::apcluster()}}.

\code{cluster_by_hdbscan()}: All other arguments are passed from \code{...} to \code{\link[dbscan:hdbscan]{dbscan::hdbscan()}}.

\code{cluster_by_MCL()}: All other arguments are passed from \code{...} to \code{\link[MCL:mcl]{MCL::mcl()}}.
}
