% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open.R
\name{prepSesame}
\alias{prepSesame}
\title{Apply a chain of sesame preprocessing functions in an arbitrary order}
\usage{
prepSesame(sdf, prep = "QCDPB", prep_args = NULL)
}
\arguments{
\item{sdf}{SigDF}

\item{prep}{code that indicates preprocessing functions and their
execution order (functions on the left is executed first).}

\item{prep_args}{optional argument list to individual functions, e.g.,
prepSesame(sdf, prep_args=list(Q=list(mask_names = "design_issue")))
sets qualityMask(sdf, mask_names = "design_issue")}
}
\value{
SigDF
}
\description{
Notes on the order of operation:
1. qualityMask and inferSpecies should go before noob and pOOBAH,
otherwise the background is too high because of Multi,
uk and other probes
2. dyeBias correction needs to happen early
3. channel inference before dyebias
4. noob should happen last, pOOBAH before noob because noob modifies oob
}
\examples{
sdf <- sesameDataGet("MM285.1.SigDF")
sdf1 <- prepSesame(sdf, "QCDPB")
}
