% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesame.R
\name{meanIntensity}
\alias{meanIntensity}
\title{Whole-dataset-wide Mean Intensity}
\usage{
meanIntensity(sdf, mask = TRUE)
}
\arguments{
\item{sdf}{a \code{SigDF}}

\item{mask}{whether to mask probes using mask column}
}
\value{
mean of all intensities
}
\description{
The function takes one single \code{SigDF} and computes mean
intensity of all the in-band measurements. This includes all Type-I
in-band measurements and all Type-II probe measurements. Both methylated
and unmethylated alleles are considered. This function outputs a single
numeric for the mean.
}
\details{
Note: mean in this case is more informative than median because
methylation level is mostly bimodal.
}
\examples{
sesameDataCache() # if not done yet
sdf <- sesameDataGet('EPIC.1.SigDF')
meanIntensity(sdf)
}
