% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesame.R
\name{getBetas}
\alias{getBetas}
\title{Get beta Values}
\usage{
getBetas(
  sdf,
  mask = TRUE,
  sum.TypeI = FALSE,
  collapseToPfx = FALSE,
  collapseMethod = c("mean", "minPval")
)
}
\arguments{
\item{sdf}{\code{SigDF}}

\item{mask}{whether to use mask}

\item{sum.TypeI}{whether to sum type I channels}

\item{collapseToPfx}{remove replicate to prefix (e.g., cg number) and
remove the suffix}

\item{collapseMethod}{mean or minPval}
}
\value{
a numeric vector, beta values
}
\description{
sum.typeI is used for rescuing beta values on
Color-Channel-Switching CCS probes. The function takes a \code{SigDF}
and returns beta value except that Type-I in-band signal and out-of-band
signal are combined. This prevents color-channel switching due to SNPs.
}
\examples{
sesameDataCache() # if not done yet
sdf <- sesameDataGet('EPIC.1.SigDF')
betas <- getBetas(sdf)
}
