% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm.R
\name{DMLpredict}
\alias{DMLpredict}
\title{Predict new data from DML}
\usage{
DMLpredict(betas, fm, pred = NULL, meta = NULL, BPPARAM = SerialParam())
}
\arguments{
\item{betas}{beta values, matrix or SummarizedExperiment
rows are probes and columns are samples.}

\item{fm}{formula}

\item{pred}{new data for prediction, useful for studying effect size.
This argument is a data.frame to specify new data.
If the argument is NULL, all combinations of all contrasts will be used
as input. It might not work if there is a continuous variable input.
One may need to explicitly provide the input in a data frame.}

\item{meta}{data frame for sample information, column names
are predictor variables (e.g., sex, age, treatment, tumor/normal etc)
and are referenced in formula. Rows are samples.
When the betas argument is a SummarizedExperiment object, this
is ignored. colData(betas) will be used instead.}

\item{BPPARAM}{number of cores for parallel processing, default to
SerialParam()
Use MulticoreParam(mc.cores) for parallel processing.
For Windows, try DoparParam or SnowParam.}
}
\value{
a SummarizedExperiment of predictions. The colData describes
the input of the prediction.
}
\description{
This function is also important for investigating factor interactions.
}
\examples{
data <- sesameDataGet('HM450.76.TCGA.matched')

## use all contrasts as new input
res <- DMLpredict(data$betas[1:10,], ~type, meta=data$sampleInfo)

## specify new input
res <- DMLpredict(data$betas[1:10,], ~type, meta=data$sampleInfo,
  pred = data.frame(type=c("Normal","Tumour")))

## note that the prediction needs to be a factor of the same
## level structure as the original training data.
pred = data.frame(type=factor(c("Normal"), levels=c("Normal","Tumour")))
res <- DMLpredict(data$betas[1:10,], ~type,
  meta=data$sampleInfo, pred = pred)

}
