% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethodSangerAlignment.R
\name{SangerAlignment-class-writeFastaSA}
\alias{SangerAlignment-class-writeFastaSA}
\alias{writeFastaSA,SangerAlignment-method}
\title{writeFastaSA}
\usage{
\S4method{writeFastaSA}{SangerAlignment}(
  object,
  outputDir = NULL,
  compress = FALSE,
  compression_level = NA,
  selection = "all"
)
}
\arguments{
\item{object}{A SangerAlignment S4 instance.}

\item{outputDir}{The output directory of generated FASTA files.}

\item{compress}{Like for the \code{save} function in base R, must be \code{TRUE} or \code{FALSE} (the default), or a single string specifying whether writing to the file is to use compression. The only type of compression supported at the moment is "gzip". This parameter will be passed to \code{writeXStringSet} function in Biostrings package.}

\item{compression_level}{This parameter will be passed to \code{writeXStringSet} function in Biostrings package.}

\item{selection}{This value can be \code{all}, \code{contigs_alignment}, \code{contigs_unalignment} or \code{all_reads}. It generates reads and contigs FASTA files.}
}
\value{
The output directory of FASTA files.
}
\description{
A SangerAlignment method which writes sequences into Fasta files.
}
\examples{
data("sangerAlignmentData")
writeFastaSA(sangerAlignmentData)
}
