% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{survfit.survTerms}
\alias{survfit.survTerms}
\title{Create survival curves}
\usage{
\method{survfit}{survTerms}(formula, ...)
}
\arguments{
\item{formula}{\code{survTerms} object: survival terms obtained after
running \code{processSurvTerms} (see examples)}

\item{...}{
  Arguments passed on to \code{\link[survival:survdiff]{survival::survdiff}}
  \describe{
    \item{\code{subset}}{
expression indicating which subset of the rows of data should be used in
the fit.  This can be a logical vector (which is replicated to have
length equal to the number of observations), a numeric vector indicating
which observation numbers are to be included (or excluded if negative),
or a character vector of row names to be included.  All observations are
included by default.
}
    \item{\code{na.action}}{
a missing-data filter function.  This is applied to the \code{model.frame} after any
subset argument has been used.  Default is \code{options()$na.action}.
}
    \item{\code{rho}}{
a scalar parameter that controls the type of test.
}
    \item{\code{timefix}}{process times through the \code{aeqSurv} function to
  eliminate potential roundoff issues.}
  }}
}
\value{
\code{survfit} object. See \code{survfit.object} for details. Methods
defined for \code{survfit} objects are \code{print}, \code{plot},
\code{lines}, and \code{points}.
}
\description{
Create survival curves
}
\details{
A survival curve is based on a tabulation of the number at risk and
  number of events at each unique death time.  When time is a floating
  point number the definition of "unique" is subject to interpretation.
  The code uses factor() to define the set.
  For further details see the documentation for the appropriate method, i.e.,
  \code{?survfit.formula} or \code{?survfit.coxph}.  

  A survfit object may contain a single curve, a set of curves (vector), a
  matrix of curves, or even a 3 way array: \code{dim(fit)} will reveal
  the dimensions.
  Predicted curves from a \code{coxph} model have one row for each
  stratum in the Cox model fit and one column for each specified
  covariate set.
  Curves from a multi-state model have one row for each stratum and
  a column for each state, the strata correspond to predictors on the
  right hand side of the equation.  The default printing and plotting
  order for curves is by column, as with other matrices.
}
\examples{
library("survival")
clinical <- read.table(text = "2549   NA ii  female
                                840   NA i   female
                                 NA 1204 iv    male
                                 NA  383 iv  female
                               1293   NA iii   male
                                 NA 1355 ii    male")
names(clinical) <- c("patient.days_to_last_followup",
                     "patient.days_to_death",
                     "patient.stage_event.pathologic_stage",
                     "patient.gender")
timeStart  <- "days_to_death"
event      <- "days_to_death"
formulaStr <- "patient.stage_event.pathologic_stage + patient.gender"
survTerms  <- processSurvTerms(clinical, censoring="right", event, timeStart,
                               formulaStr=formulaStr)
survfit(survTerms)
}
\seealso{
Other functions to analyse survival: 
\code{\link{assignValuePerSubject}()},
\code{\link{getAttributesTime}()},
\code{\link{labelBasedOnCutoff}()},
\code{\link{optimalSurvivalCutoff}()},
\code{\link{plotSurvivalCurves}()},
\code{\link{plotSurvivalPvaluesByCutoff}()},
\code{\link{processSurvTerms}()},
\code{\link{survdiffTerms}()},
\code{\link{testSurvival}()}
}
\concept{functions to analyse survival}
