% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_inclusionLevels.R
\name{quantifySplicing}
\alias{quantifySplicing}
\title{Quantify alternative splicing events}
\usage{
quantifySplicing(
  annotation,
  junctionQuant,
  eventType = c("SE", "MXE", "ALE", "AFE", "A3SS", "A5SS"),
  minReads = 10,
  genes = NULL
)
}
\arguments{
\item{annotation}{List of data frames: annotation for each alternative
splicing event type}

\item{junctionQuant}{Data frame: junction quantification}

\item{eventType}{Character: splicing event types to quantify}

\item{minReads}{Integer: values whose number of total supporting read counts
is below \code{minReads} are returned as \code{NA}}

\item{genes}{Character: gene symbols for which to quantify splicing events
(if \code{NULL}, events from all genes are quantified)}
}
\value{
Data frame with the quantification of the alternative splicing events
}
\description{
Quantify alternative splicing events
}
\examples{
# Calculate PSI for skipped exon (SE) and mutually exclusive (MXE) events
annot <- readFile("ex_splicing_annotation.RDS")
junctionQuant <- readFile("ex_junctionQuant.RDS")

quantifySplicing(annot, junctionQuant, eventType=c("SE", "MXE"))
}
\seealso{
Other functions for PSI quantification: 
\code{\link{filterPSI}()},
\code{\link{getSplicingEventTypes}()},
\code{\link{listSplicingAnnotations}()},
\code{\link{loadAnnotation}()},
\code{\link{plotRowStats}()}
}
\concept{functions for PSI quantification}
