% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_dimReduction_ica.R
\name{plotICA}
\alias{plotICA}
\title{Create multiple scatterplots from ICA}
\usage{
plotICA(ica, components = seq(10), groups = NULL, ...)
}
\arguments{
\item{ica}{Object resulting from \code{\link{performICA}()}}

\item{components}{Numeric: independent components to plot}

\item{groups}{Matrix: groups to plot indicating the index of interest of the
samples (use clinical or sample groups)}

\item{...}{
  Arguments passed on to \code{\link[pairsD3:pairsD3]{pairsD3::pairsD3}}
  \describe{
    \item{\code{group}}{a optional vector specifying the group each observation
belongs to.  Used for tooltips and colouring the observations.}
    \item{\code{subset}}{an optional vector specifying a subset of observations
to be used for plotting. Useful when you have a large number of
observations, you can specify a random subset.}
    \item{\code{labels}}{the names of the variables (column names of \code{x}
used by default).}
    \item{\code{cex}}{the magnification of the plotting symbol (default=3)}
    \item{\code{width}}{the width (and height) of the plot when viewed externally.}
    \item{\code{col}}{an optional (hex) colour for each of the levels in the group
vector.}
    \item{\code{big}}{a logical parameter.  Prevents inadvertent plotting of huge
data sets.  Default limit is 10 variables, to plot more than 10 set
\code{big=TRUE}.}
    \item{\code{theme}}{a character parameter specifying whether the theme should
be colour \code{colour} (default) or black and white \code{bw}.}
    \item{\code{opacity}}{numeric between 0 and 1. The opacity of the plotting
symbols (default 0.9).}
    \item{\code{tooltip}}{an optional vector with the tool tip to be displayed when
hovering over an observation. You can include basic html.}
    \item{\code{leftmar}}{space on the left margin}
    \item{\code{topmar}}{space on the bottom margin}
    \item{\code{diag}}{logical, whether or not the main diagonal is plotted
(scatter plot of variables against themselves).}
  }}
}
\value{
Multiple scatterplots as a \code{pairsD3} object
}
\description{
Create multiple scatterplots from ICA
}
\examples{
data <- scale(USArrests)
ica  <- fastICA::fastICA(data, n.comp=4)
plotICA(ica)

# Colour by groups
groups <- NULL
groups$sunny <- c("California", "Hawaii", "Florida")
groups$ozEntrance <- c("Kansas")
groups$novel <- c("New Mexico", "New York", "New Hampshire", "New Jersey")
plotICA(ica, groups=groups)
}
\seealso{
Other functions to analyse independent components: 
\code{\link{performICA}()}
}
\concept{functions to analyse independent components}
