% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_miso.R
\name{parseMisoGeneric}
\alias{parseMisoGeneric}
\alias{parseMisoSE}
\alias{parseMisoMXE}
\alias{parseMisoRI}
\alias{parseMisoA5SS}
\alias{parseMisoA3SS}
\alias{parseMisoTandemUTR}
\alias{parseMisoAFE}
\alias{parseMisoALE}
\title{Parse junctions of an event from MISO according to event type}
\usage{
parseMisoGeneric(event, validator, eventType, coord, plusIndex, minusIndex)

parseMisoSE(event)

parseMisoMXE(event)

parseMisoRI(event, strand)

parseMisoA5SS(event)

parseMisoA3SS(event, plusIndex, minusIndex)

parseMisoTandemUTR(event, minusIndex)

parseMisoAFE(event)

parseMisoALE(event)
}
\arguments{
\item{event}{Data.frame containing only one event with at least 7 columns as 
retrieved from the alternative splicing annotation files from MISO (GFF3
files)}

\item{validator}{Character: valid elements for each event}

\item{eventType}{Character: event type (see details for available events)}

\item{coord}{Character: coordinate positions to fill}

\item{plusIndex}{Integer: index of the coordinates for a plus strand event}

\item{minusIndex}{Integer: index of the coordinates for a minus strand event}

\item{strand}{Character: positive-sense (\code{+}) or negative-sense \code{-}
strand}
}
\value{
List of parsed junctions
}
\description{
Parse junctions of an event from MISO according to event type
}
\details{
The following event types are available to be parsed:
\itemize{
 \item{\bold{SE} (exon skipping)}
 \item{\bold{MXE} (mutually exclusive exon)}
 \item{\bold{RI} (retained intron)}
 \item{\bold{A5SS} (alternative 5' splice site)}
 \item{\bold{A3SS} (alternative 3' splice site)}
 \item{\bold{AFE} (alternative first exon)}
 \item{\bold{ALE} (alternative last exon)}
 \item{\bold{Tandem UTR}}
}
}
\examples{
# skipped exon event (SE)
event <- read.table(text = "
  chr1 SE gene 16854 18061 . - .
  chr1 SE mRNA 16854 18061 . - .
  chr1 SE exon 16854 17055 . - .
  chr1 SE exon 17233 17742 . - .
  chr1 SE exon 17915 18061 . - .
  chr1 SE mRNA 16854 18061 . - .
  chr1 SE exon 16854 17955 . - .
  chr1 SE exon 17915 18061 . - .")
psichomics:::parseMisoSE(event)

# mutually exclusive exon (MXE) event
event <- read.table(text = "
 chr1 MXE gene 764383 788090 . + .
 chr1 MXE mRNA 764383 788090 . + .
 chr1 MXE exon 764383 764484 . + .
 chr1 MXE exon 776580 776753 . + .
 chr1 MXE exon 787307 788090 . + .
 chr1 MXE mRNA 764383 788090 . + .
 chr1 MXE exon 764383 764484 . + .
 chr1 MXE exon 783034 783186 . + .
 chr1 MXE exon 787307 788090 . + .")
psichomics:::parseMisoMXE(event)

# retained intron (RI) event
event <- read.table(text = "
 chr1 RI gene 17233 17742 . - .
 chr1 RI mRNA 17233 17742 . - .
 chr1 RI exon 17233 17742 . - .
 chr1 RI mRNA 17233 17742 . - .
 chr1 RI exon 17233 17364 . - .
 chr1 RI exon 17601 17742 . - .")
psichomics:::parseMisoRI(event)

# alternative 5' splice site (A5SS) event
event <- read.table(text = "
 chr1 A5SS gene 17233 17742 . - .
 chr1 A5SS mRNA 17233 17742 . - .
 chr1 A5SS exon 17233 17368 . - .
 chr1 A5SS exon 17526 17742 . - .
 chr1 A5SS mRNA 17233 17742 . - .
 chr1 A5SS exon 17233 17368 . - .
 chr1 A5SS exon 17606 17742 . - .")
psichomics:::parseMisoA5SS(event)

# alternative 3' splice site (A3SS) event
event <- read.table(text = "
 chr1 A3SS gene 15796 16765 . - .
 chr1 A3SS mRNA 15796 16765 . - .
 chr1 A3SS exon 15796 15947 . - .
 chr1 A3SS exon 16607 16765 . - .
 chr1 A3SS mRNA 15796 16765 . - .
 chr1 A3SS exon 15796 15942 . - .
 chr1 A3SS exon 16607 16765 . - .")
psichomics:::parseMisoA3SS(event)

# Tandem UTR event
event <- read.table(text = "
 chr19 TandemUTR gene  10663759  10664625  .  -  .
 chr19 TandemUTR mRNA  10663759  10664625  .  -  .
 chr19 TandemUTR exon  10663759  10664625  .  -  .
 chr19 TandemUTR mRNA  10664223  10664625  .  -  .
 chr19 TandemUTR exon  10664223  10664625  .  -  .")
psichomics:::parseMisoTandemUTR(event)

# alternative first exon (AFE) event
event <- read.table(text = "
 chr12 AFE gene 57916659 57920171  .  +  .
 chr12 AFE mRNA 57919131 57920171  .  +  .
 chr12 AFE exon 57919131 57920171  .  +  .
 chr12 AFE mRNA 57916659 57918199  .  +  .
 chr12 AFE exon 57916659 57916794  .  +  .
 chr12 AFE exon 57917812 57917875  .  +  .
 chr12 AFE exon 57918063 57918199  .  +  .")
psichomics:::parseMisoAFE(event)

# alternative last exon (ALE) event
event <- read.table(text = "
 chr6 ALE gene 30620579 30822593  .  +  .
 chr6 ALE mRNA 30822190 30822593  .  +  .
 chr6 ALE exon 30822190 30822593  .  +  .
 chr6 ALE mRNA 30620579 30620982  .  +  .
 chr6 ALE exon 30620579 30620982  .  +  .")
psichomics:::parseMisoALE(event)
}
\seealso{
\code{\link{parseMisoEvent}()}
}
\keyword{internal}
