% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R, R/utils_interface.R
\name{loadRequiredData}
\alias{loadRequiredData}
\alias{missingDataModal}
\alias{missingDataGuide}
\title{Missing information modal template}
\usage{
loadRequiredData(modal = NULL)

missingDataModal(session, dataType, buttonId)

missingDataGuide(dataType)
}
\arguments{
\item{modal}{Character: modal identifier}

\item{session}{Shiny session}

\item{dataType}{Character: type of data missing}

\item{buttonId}{Character: identifier of button to take user to load missing
data}
}
\value{
\code{NULL} (function is only used to modify the Shiny session's
state or internal variables)
}
\description{
Missing information modal template
}
\examples{
\dontrun{
if (shiny::isRunning()) {
    session <- session$ns
    buttonInput <- "takeMeThere"
    buttonId <- ns(buttonInput)
    dataType <- "Inclusion levels"
    missingDataModal(session, buttonId, dataType)
    observeEvent(input[[buttonInput]], missingDataGuide(dataType))
}
}
}
\keyword{internal}
