% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_firebrowse.R
\name{loadTCGAdata}
\alias{loadTCGAdata}
\alias{loadFirebrowseData}
\title{Download and process TCGA data}
\usage{
loadTCGAdata(
  folder = getDownloadsFolder(),
  data = c("clinical", "junction_quantification", "RSEM_genes"),
  exclude = c(".aux.", ".mage-tab.", "MANIFEST.txt"),
  ...,
  download = TRUE
)
}
\arguments{
\item{folder}{Character: directory to store the downloaded archives (by
default, saves to \code{\link{getDownloadsFolder}()})}

\item{data}{Character: data to load (see \code{\link{getTCGAdataTypes}()})}

\item{exclude}{Character: files and folders to exclude from downloading and
from loading into R (by default, exclude files containing \code{.aux.},
\code{.mage-tab.} and \code{MANIFEST.TXT})}

\item{...}{
  Arguments passed on to \code{\link[=queryFirebrowseData]{queryFirebrowseData}}
  \describe{
    \item{\code{date}}{Character: dates of the data retrieval by FireBrowse (by default,
it uses the most recent data available)}
    \item{\code{cohort}}{Character: abbreviation of the cohorts (by default, returns
data for all cohorts)}
    \item{\code{data_type}}{Character: data types (optional)}
    \item{\code{tool}}{Character: data produced by the selected FireBrowse tools
(optional)}
    \item{\code{platform}}{Character: data generation platforms (optional)}
    \item{\code{center}}{Character: data generation centres (optional)}
    \item{\code{level}}{Integer: data levels (optional)}
    \item{\code{protocol}}{Character: sample characterization protocols (optional)}
    \item{\code{page}}{Integer: page of the results to return (optional)}
    \item{\code{page_size}}{Integer: number of records per page of results (optional)}
    \item{\code{sort_by}}{String: column used to sort the data (by default, sort by
cohort)}
  }}

\item{download}{Boolean: download missing files}
}
\value{
A list with the loaded data, unless required files are unavailable
and \code{download = FALSE} (if so, it returns the URL of files to download)
}
\description{
TCGA data obtained via \href{http://firebrowse.org/api-docs/}{FireBrowse}
}
\examples{
getTCGAcohorts()
getTCGAdataTypes()
\dontrun{
loadTCGAdata(cohort = "ACC", data_type = "Clinical")
}
}
\seealso{
Other functions associated with TCGA data retrieval: 
\code{\link{getDownloadsFolder}()},
\code{\link{getTCGAdataTypes}()},
\code{\link{isFirebrowseUp}()},
\code{\link{parseTCGAsampleTypes}()}

Other functions to load data: 
\code{\link{loadGtexData}()},
\code{\link{loadLocalFiles}()},
\code{\link{loadSRAproject}()}
}
\concept{functions associated with TCGA data retrieval}
\concept{functions to load data}
