% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{labelBasedOnCutoff}
\alias{labelBasedOnCutoff}
\title{Label groups based on a given cutoff}
\usage{
labelBasedOnCutoff(data, cutoff, label = NULL, gte = TRUE)
}
\arguments{
\item{data}{Numeric: test data}

\item{cutoff}{Numeric: test cutoff}

\item{label}{Character: label to prefix group names}

\item{gte}{Boolean: test using greater than or equal than cutoff
(\code{TRUE}) or less than or equal than cutoff (\code{FALSE})?}
}
\value{
Labelled groups
}
\description{
Label groups based on a given cutoff
}
\examples{
labelBasedOnCutoff(data=c(1, 0, 0, 1, 0, 1), cutoff=0.5)

labelBasedOnCutoff(data=c(1, 0, 0, 1, 0, 1), cutoff=0.5, "Ratio")

# Use "greater than" instead of "greater than or equal to"
labelBasedOnCutoff(data=c(1, 0, 0, 0.5, 0, 1), cutoff=0.5, gte=FALSE)
}
\seealso{
Other functions to analyse survival: 
\code{\link{assignValuePerSubject}()},
\code{\link{getAttributesTime}()},
\code{\link{optimalSurvivalCutoff}()},
\code{\link{plotSurvivalCurves}()},
\code{\link{plotSurvivalPvaluesByCutoff}()},
\code{\link{processSurvTerms}()},
\code{\link{survdiffTerms}()},
\code{\link{survfit.survTerms}()},
\code{\link{testSurvival}()}
}
\concept{functions to analyse survival}
