% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vctrs-S4-rep.R
\name{vctrs-vec_rep}
\alias{vctrs-vec_rep}
\alias{vec_rep}
\alias{vec_rep_each}
\title{replicate a vector}
\usage{
vec_rep(
  x,
  times,
  ...,
  error_call = caller_env(),
  x_arg = "x",
  times_arg = "times"
)

vec_rep_each(
  x,
  times,
  ...,
  error_call = caller_env(),
  x_arg = "x",
  times_arg = "times"
)
}
\arguments{
\item{x}{A vector.}

\item{times}{For \code{vec_rep()}, a single integer for the number of times to repeat
the entire vector.

For \code{vec_rep_each()}, an integer vector of the number of times to repeat
each element of \code{x}. \code{times} will be \link[vctrs:theory-faq-recycling]{recycled} to
the size of \code{x}.}

\item{...}{These dots are for future extensions and must be empty.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}

\item{x_arg, times_arg}{Argument names for errors.}
}
\value{
a new S3 or S4 vector replicated by specified times
}
\description{
A re-export of \code{\link[vctrs:vec-rep]{vctrs::vec_rep}} and
\code{\link[vctrs:vec-rep]{vctrs::vec_rep_each}} as an S7 generic
function to allow \code{S4Vectors}.
}
\examples{
vec_rep(1:2, times = 5)
vec_rep(S4Vectors::Rle(1:2), times = 5)

vec_rep_each(1:2, times = 5)
vec_rep_each(S4Vectors::Rle(1:2), times = 5)
}
