% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vctrs-S4-chop.R
\name{vctrs-vec_chop}
\alias{vctrs-vec_chop}
\alias{vec_chop}
\title{chop a vector}
\usage{
vec_chop(x, ..., indices = NULL)
}
\arguments{
\item{x}{A vector}

\item{...}{These dots are for future extensions and must be empty.}

\item{indices}{For \code{vec_chop()}, a list of positive integer vectors to
slice \code{x} with, or \code{NULL}. Can't be used if \code{sizes} is already specified.
If both \code{indices} and \code{sizes} are \code{NULL}, \code{x} is split into its individual
elements, equivalent to using an \code{indices} of \code{as.list(vec_seq_along(x))}.

For \code{list_unchop()}, a list of positive integer vectors specifying the
locations to place elements of \code{x} in. Each element of \code{x} is recycled to
the size of the corresponding index vector. The size of \code{indices} must
match the size of \code{x}. If \code{NULL}, \code{x} is combined in the order it is
provided in, which is equivalent to using \code{\link[vctrs:vec_c]{vec_c()}}.}
}
\value{
a S3 or S4 vector
}
\description{
A re-export of \code{\link[vctrs:vec_chop]{vctrs::vec_chop}} as an S7 generic
function to allow \code{S4Vectors}.
}
\examples{
vec_chop(1L)
vec_chop(S4Vectors::Rle(c(rep(1, 3), rep(4, 5))), indices = list(c(2, 3, 4), c(1, 5:8)))

}
